import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

/**
 * Preferences JDialog
 */
public class ConfigMTTDialog extends JDialog implements ActionListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8741123825711519822L;

	protected JLabel lPathMaude, lPathToolMaude, lPathFullMaude, lPathMttTrans,
			lPortMaudeLocal, lPortMaude, lPathCime, lPathToolCime,
			lPortCimeLocal, lPortCime, lPathMuterm, lPortMuterm,
			lPathToolMuterm, lPathToolHaskell, lPortHaskellLocal;

	protected JTextField tPathToolMaude, tPathFullMaude, tPathMttTrans,
			tPortMaudeLocal, tPortMaude, tPathToolCime, tPortCimeLocal,
			tPortCiME, tPortMuTerm, tPathToolMuTerm, tPathToolHaskell,
			tPortHaskellLocal, tPortAprove, tPathToolAprove;

	protected JPanelIp ipMaude, ipCiME, ipMuTerm, ipAprove;

	protected JRadioButton rbServerMaude, rbServerCiME, rbServerMuTerm,
			rbServerAprove, rbCiMEnotA, rbMaudenotA, rbMuTermnotA,
			rbAprovenotA;

	protected JButton bPathToolMaude, bPathFullMaude, bPathMttTrans,
			bPathToolCime, bPathToolMuTerm, bPathToolHaskell, bOk, bCancel,
			bPathToolAprove;

	protected Configuration config;

	public boolean OK = false;

	protected static boolean cambiaCiME = false;

	protected static boolean cambiaMaude = false;

	protected static boolean cambiaMuTerm = false;

	protected static boolean cambiaAprove = false;

	private GUIMTT gui;

	public ConfigMTTDialog(GUIMTT frame, Configuration config) {
		super(frame, "Preferences...", true);

		this.config = config;
		this.gui = frame;

		// //////////////// CiME /////////////////

		ipCiME = new JPanelIp(config.urlCiME);
		tPortCiME = new JTextField(new Integer(config.portCiME).toString(), 5);

		tPathToolCime = new JTextField(config.localCiME, 30);
		// tPortCimeLocal = new JTextField(new
		// Integer(config.portCiMELocal).toString(), 5);

		bPathToolCime = new JButton("Browse...");
		bPathToolCime.addActionListener(new SelectFile());
		bPathToolCime.setActionCommand("toolCime");

		rbCiMEnotA = new JRadioButton("CiME not available");
		rbCiMEnotA.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortCiME.setEnabled(false);
				ipCiME.setEnabled(false);
				tPathToolCime.setEnabled(false);
				bPathToolCime.setEnabled(false);

			}
		});
		rbServerCiME = new JRadioButton("Remote CiME Server");
		rbServerCiME.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortCiME.setEnabled(true);
				ipCiME.setEnabled(true);
				tPathToolCime.setEnabled(false);
				bPathToolCime.setEnabled(false);
			}
		});
		JRadioButton rbLocalCiME = new JRadioButton("Local CiME");
		rbLocalCiME.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortCiME.setEnabled(false);
				ipCiME.setEnabled(false);
				tPathToolCime.setEnabled(true);
				bPathToolCime.setEnabled(true);
			}
		});
		ButtonGroup bgCiME = new ButtonGroup();
		bgCiME.add(rbServerCiME);
		bgCiME.add(rbLocalCiME);
		bgCiME.add(rbCiMEnotA);
		if (config.isServerCiME) {
			rbServerCiME.doClick();
		} else if (config.isnotACime) {
			rbCiMEnotA.doClick();
		} else {
			rbLocalCiME.doClick();
		}

		JPanel buttonsCiME = new JPanel(new GridLayout(3, 1));
		buttonsCiME.add(rbCiMEnotA);
		buttonsCiME.add(rbServerCiME);
		buttonsCiME.add(rbLocalCiME);

		JPanel panelServerCime = new JPanel();
		panelServerCime.add(new JLabel("Port: "));
		panelServerCime.add(tPortCiME);
		panelServerCime.add(ipCiME);

		JPanel panelLocalCiME = new JPanel();
		panelLocalCiME.add(new JLabel("Tool's path: "));
		panelLocalCiME.add(tPathToolCime);
		panelLocalCiME.add(bPathToolCime);

		JPanel optionsCiMEPanel = new JPanel(new GridLayout(9, 1));
		optionsCiMEPanel.add(new JLabel(" "));
		optionsCiMEPanel.add(new JLabel(" "));
		optionsCiMEPanel.add(new JLabel(" "));
		optionsCiMEPanel.add(new JLabel(" "));
		optionsCiMEPanel.add(panelServerCime);
		optionsCiMEPanel.add(new JLabel(" "));
		optionsCiMEPanel.add(new JLabel(" "));
		optionsCiMEPanel.add(panelLocalCiME);
		optionsCiMEPanel.add(new JLabel(" "));

		JPanel panelCiME = new JPanel(new BorderLayout());
		panelCiME.add(buttonsCiME, BorderLayout.WEST);
		panelCiME.add(optionsCiMEPanel, BorderLayout.CENTER);

		// //////////////// Maude /////////////////

		ipMaude = new JPanelIp(config.urlMaude);
		tPortMaude = new JTextField(new Integer(config.portMaude).toString(), 5);

		tPathToolMaude = new JTextField(config.localMaude, 30);
		// tPortMaudeLocal = new JTextField(new
		// Integer(config.portMaudeLocal).toString(), 5);
		tPathFullMaude = new JTextField(config.localFullMaude, 30);
		tPathMttTrans = new JTextField(config.localMttTransf, 30);

		bPathToolMaude = new JButton("Browse...");
		bPathFullMaude = new JButton("Browse...");
		bPathMttTrans = new JButton("Browse...");
		bPathToolMaude.addActionListener(new SelectFile());
		bPathToolMaude.setActionCommand("toolMaude");
		bPathFullMaude.addActionListener(new SelectFile());
		bPathFullMaude.setActionCommand("fullMaude");
		bPathMttTrans.addActionListener(new SelectFile());
		bPathMttTrans.setActionCommand("mttTransMaude");

		lPathToolMaude = new JLabel("Path tool Maude: ");
		lPathFullMaude = new JLabel("Path full Maude: ");
		lPathMttTrans = new JLabel("Path MTT-Transf: ");
		lPortMaudeLocal = new JLabel("PortLocal: ");

		rbServerMaude = new JRadioButton("Remote Maude Server");
		rbServerMaude.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortMaude.setEnabled(true);
				ipMaude.setEnabled(true);
				tPathToolMaude.setEnabled(false);
				bPathToolMaude.setEnabled(false);
				tPathFullMaude.setEnabled(false);
				bPathFullMaude.setEnabled(false);
				tPathMttTrans.setEnabled(false);
				bPathMttTrans.setEnabled(false);
			}
		});
		JRadioButton rbLocalMaude = new JRadioButton("Local Maude");
		rbLocalMaude.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortMaude.setEnabled(false);
				ipMaude.setEnabled(false);
				tPathToolMaude.setEnabled(true);
				bPathToolMaude.setEnabled(true);
				tPathFullMaude.setEnabled(true);
				bPathFullMaude.setEnabled(true);
				tPathMttTrans.setEnabled(true);
				bPathMttTrans.setEnabled(true);
			}
		});

		ButtonGroup bgMaude = new ButtonGroup();
		bgMaude.add(rbServerMaude);
		bgMaude.add(rbLocalMaude);
		if (config.isServerMaude) {
			rbServerMaude.doClick();
		} else {
			rbLocalMaude.doClick();
		}

		JPanel buttonsMaude = new JPanel(new GridLayout(2, 1));
		buttonsMaude.add(rbServerMaude);
		buttonsMaude.add(rbLocalMaude);

		JPanel panelServerMaude = new JPanel(new FlowLayout());
		panelServerMaude.add(new JLabel("Port: "));
		panelServerMaude.add(tPortMaude);
		panelServerMaude.add(ipMaude);

		JPanel panelPathToolMaude = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		panelPathToolMaude.add(new JLabel("Maude's path: "));
		panelPathToolMaude.add(tPathToolMaude);
		panelPathToolMaude.add(bPathToolMaude);
		JPanel panelPathFullMaude = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		panelPathFullMaude.add(new JLabel("Full Maude's path: "));
		panelPathFullMaude.add(tPathFullMaude);
		panelPathFullMaude.add(bPathFullMaude);
		JPanel panelPathMttTrans = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		panelPathMttTrans.add(new JLabel("Transformation file: "));
		panelPathMttTrans.add(tPathMttTrans);
		panelPathMttTrans.add(bPathMttTrans);

		JPanel optionsMaudePanel = new JPanel(new GridLayout(9, 1));
		optionsMaudePanel.add(new JLabel(" "));
		optionsMaudePanel.add(new JLabel(" "));
		optionsMaudePanel.add(panelServerMaude);
		optionsMaudePanel.add(new JLabel(" "));
		optionsMaudePanel.add(new JLabel(" "));
		optionsMaudePanel.add(panelPathToolMaude);
		optionsMaudePanel.add(panelPathFullMaude);
		optionsMaudePanel.add(panelPathMttTrans);

		JPanel panelMaude = new JPanel(new BorderLayout());
		panelMaude.add(buttonsMaude, BorderLayout.WEST);
		panelMaude.add(optionsMaudePanel, BorderLayout.CENTER);

		// //////////////// Muterm /////////////////

		ipMuTerm = new JPanelIp(config.urlHaskell);
		tPortMuTerm = new JTextField(new Integer(config.portMuTerm).toString(),
				5);

		tPathToolMuTerm = new JTextField(config.localMuTerm, 30);
		tPathToolHaskell = new JTextField(config.localHaskell, 30);
		tPortHaskellLocal = new JTextField(new Integer(config.portMuTermLocal)
				.toString(), 5);

		bPathToolMuTerm = new JButton("Browse...");
		bPathToolHaskell = new JButton("Browse...");
		bPathToolMuTerm.addActionListener(new SelectFile());
		bPathToolMuTerm.setActionCommand("toolMuterm");
		bPathToolHaskell.addActionListener(new SelectFile());
		bPathToolHaskell.setActionCommand("toolHaskell");

		rbMuTermnotA = new JRadioButton("MuTerm not available");
		rbMuTermnotA.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortMuTerm.setEnabled(false);
				ipMuTerm.setEnabled(false);
				tPathToolMuTerm.setEnabled(false);
				tPathToolHaskell.setEnabled(false);
				bPathToolHaskell.setEnabled(false);
				bPathToolMuTerm.setEnabled(false);
			}
		});
		rbServerMuTerm = new JRadioButton("Remote MuTerm Server");
		rbServerMuTerm.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortMuTerm.setEnabled(true);
				ipMuTerm.setEnabled(true);
				tPathToolMuTerm.setEnabled(false);
				bPathToolMuTerm.setEnabled(false);
				tPathToolHaskell.setEnabled(false);
				bPathToolHaskell.setEnabled(false);
			}
		});
		JRadioButton rbLocalMuTerm = new JRadioButton("Local MuTerm");
		rbLocalMuTerm.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortMuTerm.setEnabled(false);
				ipMuTerm.setEnabled(false);
				tPathToolMuTerm.setEnabled(true);
				bPathToolMuTerm.setEnabled(true);
				tPathToolHaskell.setEnabled(true);
				bPathToolHaskell.setEnabled(true);
			}
		});

		ButtonGroup bgMuTerm = new ButtonGroup();
		bgMuTerm.add(rbMuTermnotA);
		bgMuTerm.add(rbServerMuTerm);
		bgMuTerm.add(rbLocalMuTerm);
		if (config.isnotAMuTerm) {
			rbMuTermnotA.doClick();
		} else if (config.isServerMuTerm) {
			rbServerMuTerm.doClick();
		} else {
			rbLocalMuTerm.doClick();
		}

		JPanel buttonsMuTerm = new JPanel(new GridLayout(3, 1));
		buttonsMuTerm.add(rbMuTermnotA);
		buttonsMuTerm.add(rbServerMuTerm);
		buttonsMuTerm.add(rbLocalMuTerm);

		JPanel panelServerMuTerm = new JPanel();
		panelServerMuTerm.add(new JLabel("Port: "));
		panelServerMuTerm.add(tPortMuTerm);
		panelServerMuTerm.add(ipMuTerm);

		JPanel panelPathToolHaskell = new JPanel(new FlowLayout(
				FlowLayout.RIGHT));
		panelPathToolHaskell.add(new JLabel("Haskell's path: "));
		panelPathToolHaskell.add(tPathToolHaskell);
		panelPathToolHaskell.add(bPathToolHaskell);
		JPanel panelPathToolMuTerm = new JPanel(
				new FlowLayout(FlowLayout.RIGHT));
		panelPathToolMuTerm.add(new JLabel("MuTerm's path: "));
		panelPathToolMuTerm.add(tPathToolMuTerm);
		panelPathToolMuTerm.add(bPathToolMuTerm);

		JPanel optionsMuTermPanel = new JPanel(new GridLayout(9, 1));
		optionsMuTermPanel.add(new JLabel(" "));
		optionsMuTermPanel.add(new JLabel(" "));
		optionsMuTermPanel.add(new JLabel(" "));
		optionsMuTermPanel.add(new JLabel(" "));
		optionsMuTermPanel.add(panelServerMuTerm);
		optionsMuTermPanel.add(new JLabel(" "));
		optionsMuTermPanel.add(panelPathToolMuTerm);
		optionsMuTermPanel.add(panelPathToolHaskell);
		optionsMuTermPanel.add(new JLabel(" "));

		JPanel panelMuTerm = new JPanel(new BorderLayout());
		panelMuTerm.add(buttonsMuTerm, BorderLayout.WEST);
		panelMuTerm.add(optionsMuTermPanel, BorderLayout.CENTER);

		// ////////////////Aprove /////////////////

		ipAprove = new JPanelIp(config.urlAprove);
		tPortAprove = new JTextField(new Integer(config.portAprove).toString(),
				5);

		tPathToolAprove = new JTextField(config.localAprove, 30);
		// tPortAproveLocal = new JTextField(new
		// Integer(config.portAproveLocal).toString(), 5);

		bPathToolAprove = new JButton("Browse...");
		bPathToolAprove.addActionListener(new SelectFile());
		bPathToolAprove.setActionCommand("toolAprove");

		rbAprovenotA = new JRadioButton("Aprove not available");
		rbAprovenotA.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortAprove.setEnabled(false);
				ipAprove.setEnabled(false);
				tPathToolAprove.setEnabled(false);
				bPathToolAprove.setEnabled(false);
			}
		});
		rbServerAprove = new JRadioButton("Remote Aprove Server");
		rbServerAprove.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortAprove.setEnabled(true);
				ipAprove.setEnabled(true);
				tPathToolAprove.setEnabled(false);
				bPathToolAprove.setEnabled(false);
			}
		});
		JRadioButton rbLocalAprove = new JRadioButton("Local Aprove");
		rbLocalAprove.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				tPortAprove.setEnabled(false);
				ipAprove.setEnabled(false);
				tPathToolAprove.setEnabled(true);
				bPathToolAprove.setEnabled(true);
			}
		});

		ButtonGroup bgAprove = new ButtonGroup();
		bgAprove.add(rbAprovenotA);
		bgAprove.add(rbServerAprove);
		bgAprove.add(rbLocalAprove);
		if (config.isnotAAprove) {
			rbAprovenotA.doClick();
		} else if (config.isServerAprove) {
			rbServerAprove.doClick();
		} else {
			rbLocalAprove.doClick();
		}

		JPanel buttonsAprove = new JPanel(new GridLayout(3, 1));
		buttonsAprove.add(rbAprovenotA);
		buttonsAprove.add(rbServerAprove);
		buttonsAprove.add(rbLocalAprove);

		JPanel panelServerAprove = new JPanel();
		panelServerAprove.add(new JLabel("Port: "));
		panelServerAprove.add(tPortAprove);
		panelServerAprove.add(ipAprove);

		JPanel panelPathToolAprove = new JPanel(
				new FlowLayout(FlowLayout.RIGHT));
		panelPathToolAprove.add(new JLabel("Aprove's path: "));
		panelPathToolAprove.add(tPathToolAprove);
		panelPathToolAprove.add(bPathToolAprove);

		JPanel optionsAprovePanel = new JPanel(new GridLayout(9, 1));
		optionsAprovePanel.add(new JLabel(" "));
		optionsAprovePanel.add(new JLabel(" "));
		optionsAprovePanel.add(new JLabel(" "));
		optionsAprovePanel.add(new JLabel(" "));
		optionsAprovePanel.add(panelServerAprove);
		optionsAprovePanel.add(new JLabel(" "));
		optionsAprovePanel.add(new JLabel(" "));
		optionsAprovePanel.add(panelPathToolAprove);
		optionsAprovePanel.add(new JLabel(" "));

		JPanel panelAprove = new JPanel(new BorderLayout());
		panelAprove.add(buttonsAprove, BorderLayout.WEST);
		panelAprove.add(optionsAprovePanel, BorderLayout.CENTER);

		bOk = new JButton("Ok");
		bCancel = new JButton("Cancel");
		bOk.setMnemonic('O');
		bCancel.setMnemonic('C');
		bOk.addActionListener(this);
		bCancel.addActionListener(this);

		JPanel panelButton = new JPanel(new FlowLayout());
		panelButton.add(bOk);
		panelButton.add(bCancel);

		JTabbedPane optionsPanel = new JTabbedPane();
		optionsPanel.addTab("CiME", panelCiME);
		optionsPanel.addTab("Maude", panelMaude);
		optionsPanel.addTab("MuTerm", panelMuTerm);
		optionsPanel.addTab("Aprove", panelAprove);

		getContentPane().add(optionsPanel, BorderLayout.CENTER);
		getContentPane().add(panelButton, BorderLayout.SOUTH);
	}

	public void openDialog() {
		pack();
		setVisible(true);
	}

	public void actionPerformed(ActionEvent e) {

		if (MTT.lanzaMTT) {
			if (e.getSource() == bOk) {
				OK = true;
				// CiME
				if (rbCiMEnotA.isSelected()) {
					config.CiMEnotAStarted = true;
					config.isnotACime = true;
					config.isServerCiME = false;
//					gui.rbCiME.setEnabled(false);
					gui.terminationTool.setEnabledAt(0, false);

				} else if (rbServerCiME.isSelected()) {
					config.urlCiME = ipCiME.toString();
					config.portCiME = Integer.parseInt(tPortCiME.getText());
					config.CiMEnotAStarted = false;
					config.isServerCiME = true;
					config.isnotACime = false;
//					gui.rbCiME.setEnabled(true);
					gui.terminationTool.setEnabledAt(0, true);
				} else {

					config.localCiME = tPathToolCime.getText();
					config.CiMEnotAStarted = false;
					config.isServerCiME = false;
					config.isnotACime = false;
//					gui.rbCiME.setEnabled(true);
					gui.terminationTool.setEnabledAt(0, true);

				}
				// Maude
				if (rbServerMaude.isSelected()) {
					config.urlMaude = ipMaude.toString();
					config.portMaude = Integer.parseInt(tPortMaude.getText());
					config.isServerMaude = true;

				} else {

					this.config.localMaude = this.tPathToolMaude.getText();
					this.config.localFullMaude = this.tPathFullMaude.getText();
					this.config.localMttTransf = this.tPathMttTrans.getText();
					this.config.isServerMaude = false;
				}
				// MuTerm
				if (rbMuTermnotA.isSelected()) {
					config.MuTermnotAStarted = true;
					config.isnotAMuTerm = true;
					config.isServerMuTerm = false;
//					gui.rbMuTerm.setEnabled(false);
					gui.terminationTool.setEnabledAt(1, false);
				} else if (rbServerMuTerm.isSelected()) {
					this.config.urlHaskell = this.ipMuTerm.toString();
					this.config.portMuTerm = Integer.parseInt(tPortMuTerm
							.getText());
					config.MuTermnotAStarted = false;
					this.config.isServerMuTerm = true;
					config.isnotAMuTerm = false;
//					gui.rbMuTerm.setEnabled(true);
					gui.terminationTool.setEnabledAt(1, true);
				} else {
					this.config.localMuTerm = this.tPathToolMuTerm.getText();
					this.config.localHaskell = this.tPathToolHaskell.getText();
					config.MuTermnotAStarted = false;
					this.config.isServerMuTerm = false;
					config.isnotAMuTerm = false;
//					gui.rbMuTerm.setEnabled(true);
					gui.terminationTool.setEnabledAt(1, true);
				}
				// Aprove
				if (rbAprovenotA.isSelected()) {
					config.AprovenotAStarted = true;
					config.isnotAAprove = true;
					config.isServerAprove = false;
//					gui.rbAprove.setEnabled(false);
					gui.terminationTool.setEnabledAt(0, false);

				} else if (rbServerAprove.isSelected()) {
					config.urlAprove = ipAprove.toString();
					config.portAprove = Integer.parseInt(tPortAprove.getText());
					config.AprovenotAStarted = false;
					config.isServerAprove = true;
					config.isnotAAprove = false;
//					gui.rbAprove.setEnabled(true);
					gui.terminationTool.setEnabledAt(0, true);
				} else {

					config.localAprove = tPathToolAprove.getText();
					config.AprovenotAStarted = false;
					config.isServerAprove = false;
					config.isnotAAprove = false;
//					gui.rbAprove.setEnabled(true);
					gui.terminationTool.setEnabledAt(0, true);

				}
				config.save();
			} else if (e.getSource() == bCancel) {
				OK = false;
			}
			this.setVisible(false);

		} else { // lanza opendialog CtrlMTT
			if (e.getSource() == bOk) {
				OK = true;
				// Cime
				if (rbCiMEnotA.isSelected()) {
					config.isnotACime = true;
					config.isServerCiME = false;
//					gui.rbCiME.setEnabled(false);
					gui.terminationTool.setEnabledAt(0, false);
					try {
						if (!config.cimeOutputListener.isAlive()) { // Close
																	// CiME
							config.closeConnectionCiME(gui);
						}
					} catch (IOException ioe) {
						if (MTT.DEBUG)
							System.out.println(ioe.getMessage());
					}

				} else if (rbServerCiME.isSelected()) {
					config.urlCiME = ipCiME.toString();
					config.portCiME = Integer.parseInt(tPortCiME.getText());
					config.isServerCiME = true;
					config.isnotACime = false;
					config.CiMEnotAStarted = false;
//					gui.rbCiME.setEnabled(true);
					gui.terminationTool.setEnabledAt(0, true);
				} else {
					if (!config.localCiME.equalsIgnoreCase(tPathToolCime
							.getText())) {
						cambiaCiME = true;
						config.localCiME = tPathToolCime.getText();
					}
					try {
						if (!config.cimeOutputListener.isAlive()) { // Restart
																	// Cime
							config.establishConnectionCiME(gui);
						}

					} catch (IOException ioe) {
						if (MTT.DEBUG)
							System.out.println(ioe.getMessage());
					}

					config.isServerCiME = false;
					config.isnotACime = false;
					config.CiMEnotAStarted = false;
//					gui.rbCiME.setEnabled(true);
					gui.terminationTool.setEnabledAt(0, true);

				}
				// Maude
				if (rbServerMaude.isSelected()) {
					config.urlMaude = ipMaude.toString();
					config.portMaude = Integer.parseInt(tPortMaude.getText());
					config.isServerMaude = true;
					gui.terminationTool.setEnabledAt(2, true);
				} else {
					if (!config.localMaude.equalsIgnoreCase(tPathToolMaude
							.getText())
							|| !config.localFullMaude
									.equalsIgnoreCase(tPathFullMaude.getText())
							|| !config.localMttTransf
									.equalsIgnoreCase(tPathMttTrans.getText())) {
						cambiaMaude = true;
						this.config.localMaude = this.tPathToolMaude.getText();
						this.config.localFullMaude = this.tPathFullMaude
								.getText();
						this.config.localMttTransf = this.tPathMttTrans
								.getText();

					}
					this.config.isServerMaude = false;

				}
				// MuTerm
				if (rbMuTermnotA.isSelected()) {
					config.isnotAMuTerm = true;
					config.isServerMuTerm = false;
//					gui.rbMuTerm.setEnabled(false);
					gui.terminationTool.setEnabledAt(1, false);
					try {
						if (!config.mutermOutputListener.isAlive()) { // Close MuTerm
							config.closeConnectionMuTerm(gui);
						}
					} catch (IOException ioe) {
						if (MTT.DEBUG)
							System.out.println(ioe.getMessage());
					}
				} else if (rbServerMuTerm.isSelected()) {
					this.config.urlHaskell = this.ipMuTerm.toString();
					this.config.portMuTerm = Integer.parseInt(tPortMuTerm.getText());
					this.config.isServerMuTerm = true;
					config.isnotAMuTerm = false;
					config.MuTermnotAStarted = false;
//					gui.rbMuTerm.setEnabled(true);
					gui.terminationTool.setEnabledAt(1, true);
				} else {
					if (!config.localMuTerm.equalsIgnoreCase(tPathToolMuTerm.getText())
							|| !config.localHaskell.equalsIgnoreCase(tPathToolHaskell.getText())) {
						cambiaMuTerm = true;
						this.config.localMuTerm 
							= this.tPathToolMuTerm.getText();
						this.config.localHaskell 
							= this.tPathToolHaskell.getText();
					}
					try {
						if (!config.mutermOutputListener.isAlive()) { // Restart
																		// Muterm
							config.establishConnectionMuTerm(gui);
						}

					} catch (IOException ioe) {
						if (MTT.DEBUG)
							System.out.println(ioe.getMessage());
					}
					this.config.isServerMuTerm = false;
					config.isnotAMuTerm = false;
					config.MuTermnotAStarted = false;
//					gui.rbMuTerm.setEnabled(true);
					gui.terminationTool.setEnabledAt(1, true);
				}
/*				// Aprove
				if (rbAprovenotA.isSelected()) {
					config.isnotAAprove = true;
					config.isServerAprove = false;
					gui.rbAprove.setEnabled(false);
					gui.terminationTool.setEnabledAt(0, false);
					try {
						if (!config.aproveOutputListener.isAlive()) { // Close
																		// Aprove
							config.closeConnectionAprove(gui);
						}
					} catch (IOException ioe) {
						if (MTT.DEBUG)
							System.out.println(ioe.getMessage());
					}

				} else if (rbServerAprove.isSelected()) {
					config.urlAprove = ipAprove.toString();
					config.portAprove = Integer.parseInt(tPortAprove.getText());
					config.isServerAprove = true;
					config.isnotAAprove = false;
					config.AprovenotAStarted = false;
					gui.rbAprove.setEnabled(true);
					gui.terminationTool.setEnabledAt(0, true);
				} else {
					if (!config.localAprove.equalsIgnoreCase(tPathToolAprove
							.getText())) {
						cambiaAprove = true;
						config.localAprove = tPathToolAprove.getText();
					}
					try {
						if (!config.aproveOutputListener.isAlive()) { // Restart
																		// Aprove
							config.establishConnectionAprove(gui);
						}

					} catch (IOException ioe) {
						if (MTT.DEBUG)
							System.out.println(ioe.getMessage());
					}

					config.isServerAprove = false;
					config.isnotAAprove = false;
					config.AprovenotAStarted = false;
					gui.rbAprove.setEnabled(true);
					gui.terminationTool.setEnabledAt(0, true);
				}
*/
				config.save();
			} else if (e.getSource() == bCancel) {
				OK = false;
			}
			this.setVisible(false);
		}

	}

	private class SelectFile implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			JFileChooser c = new JFileChooser();
			int rVal = c.showDialog(ConfigMTTDialog.this, "Select");
			if (rVal == JFileChooser.APPROVE_OPTION) {
				if (e.getActionCommand().equals("toolMaude")) {
					tPathToolMaude.setText(c.getSelectedFile()
							.getAbsolutePath());
				} else if (e.getActionCommand().equals("fullMaude")) {
					tPathFullMaude.setText(c.getSelectedFile()
							.getAbsolutePath());
				} else if (e.getActionCommand().equals("mttTransMaude")) {
					tPathMttTrans
							.setText(c.getSelectedFile().getAbsolutePath());
				} else if (e.getActionCommand().equals("toolCime")) {
					tPathToolCime
							.setText(c.getSelectedFile().getAbsolutePath());
				} else if (e.getActionCommand().equals("toolHaskell")) {
					tPathToolHaskell.setText(c.getSelectedFile()
							.getAbsolutePath());
				} else if (e.getActionCommand().equals("toolMuterm")) {
					tPathToolMuTerm.setText(c.getSelectedFile()
							.getAbsolutePath());
				} else if (e.getActionCommand().equals("toolAprove")) {
					tPathToolAprove.setText(c.getSelectedFile()
							.getAbsolutePath());
				}
			}
		}
	}

	protected class JPanelIp extends JPanel {
		/**
		 * 
		 */
		private static final long serialVersionUID = 6996565581671035769L;

		private JTextField aCom, bCom, cCom, dCom;

		private JLabel lIp, punto, punto1, punto2;

		public JPanelIp(String ip) {
			super();

			String trozoA = "";
			String trozoB = "";
			String trozoC = "";
			String trozoD = "";
			if (ip != null && !ip.equals("")) {
				StringTokenizer trozos = new StringTokenizer(ip, ".");
				if (trozos.hasMoreTokens()) {
					trozoA = trozos.nextToken();
				}
				if (trozos.hasMoreTokens()) {
					trozoB = trozos.nextToken();
				}
				if (trozos.hasMoreTokens()) {
					trozoC = trozos.nextToken();
				}
				if (trozos.hasMoreTokens()) {
					trozoD = trozos.nextToken();
				}
			}

			lIp = new JLabel("   IP: ");
			this.add(lIp);
			aCom = new JTextField(trozoA, 4);
			aCom.setHorizontalAlignment(JTextField.RIGHT);
			bCom = new JTextField(trozoB, 4);
			bCom.setHorizontalAlignment(JTextField.RIGHT);
			cCom = new JTextField(trozoC, 4);
			cCom.setHorizontalAlignment(JTextField.RIGHT);
			dCom = new JTextField(trozoD, 4);
			dCom.setHorizontalAlignment(JTextField.RIGHT);

			punto = new JLabel(".");
			punto1 = new JLabel(".");
			punto2 = new JLabel(".");

			this.add(aCom);
			this.add(punto);
			this.add(bCom);
			this.add(punto1);
			this.add(cCom);
			this.add(punto2);
			this.add(dCom);
		}

		public String toString() {
			return getA() + '.' + getB() + '.' + getC() + '.' + getD();
		}

		public String getA() {
			return aCom.getText();
		}

		public String getB() {
			return bCom.getText();
		}

		public String getC() {
			return cCom.getText();
		}

		public String getD() {
			return dCom.getText();
		}

		public void setA(String s) {
			aCom.setText(s);
		}

		public void setB(String s) {
			bCom.setText(s);
		}

		public void setC(String s) {
			cCom.setText(s);
		}

		public void setD(String s) {
			dCom.setText(s);
		}

		public InetAddress inetAddress() throws Exception {
			byte[] bytes = { Byte.parseByte(getA()), Byte.parseByte(getB()),
					Byte.parseByte(getC()), Byte.parseByte(getD()) };

			return InetAddress.getByAddress(bytes);
		}

		public void setEnabled(boolean b) {
			aCom.setEnabled(b);
			bCom.setEnabled(b);
			cCom.setEnabled(b);
			dCom.setEnabled(b);
			lIp.setEnabled(b);
			punto.setEnabled(b);
			punto1.setEnabled(b);
			punto2.setEnabled(b);

		}

	}
}
