
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.net.*;

public class CtrlMTT implements ActionListener {
	protected GUIMTT gui;

	protected Configuration config;

	protected String maudeTransfType = "complete";

	// "complete" is selected by default
	protected String criterion = "minimal";

	// "dp" is selected by default
	protected boolean LinearInterpr = true;

	// "linear" is selected by default;
	protected boolean SimpleInterpr = false;

	// "simple" is selected by default;
	protected boolean SimpleMixedInterpr = true;

	// "simple-mixed" is selected by default;
	protected int maxCoeffLinear = 2;

	// by default maximum polynomial coefficient linear
	protected int maxCoeffSimple = 0;

	// by default maximum polynomial coefficient simple
	protected int maxCoeffSimpleMixed = 6;

	// by default maximum polynomial coefficient simple-mixed
	protected String strategyTransfType = "Eliminate CS information";

	// by default, Eliminate CS information is selected
	protected String criterionTermMuTerm = "linearMuTerm";
	
//	protected String runme = File.class.getResource("runme").getPath();

	// Error message obtained by bad text entered to the tools
	protected final static String ERROR_TEXT_CIME = "Error. Input to CiME is not correct.";

	protected final static String ERROR_TEXT_MUTERM = "Error. Input to MU-TERM is not correct.";

	protected String command;
	public CtrlMTT(GUIMTT gui, Configuration config) {
		this.gui = gui;
		this.config = config;
	}

	protected String findName(String text) {
		int beginIndex = text.lastIndexOf("let") + 3; // removes the "let"
														// word
		int endIndex;
		if (criterion.equals("minimal")) {
			endIndex = text.lastIndexOf("= HTRS");
		} else {
			endIndex = text.lastIndexOf("= TRS");
		}
		text = text.substring(beginIndex, endIndex);
		return text;
	}

	protected String createPolyInterp() {
		String text = "{";
		boolean first = true;
		if (LinearInterpr) {
			text += "(\"linear\", " + gui.getMaxCoeffLinear() + ")";
			first = false;
		}
		if (SimpleInterpr) {
			text += (first ? "" : "; ") + "(\"simple\", "
					+ gui.getMaxCoeffSimple() + ")";
			first = false;
		}
		if (SimpleMixedInterpr) {
			text += (first ? "" : "; ") + "(\"simple-mixed\", "
					+ gui.getMaxCoeffSimpleMixed() + ")";
		}
		return text + "}";
	}
	
	protected void doTransformation(String command) throws IOException{
		// We request the corresponding transformation
		if (!strategyTransfType.equals("Eliminate CS information")) {
			config.mutermWrapper.toolOut.println("5"); // Termination
			config.mutermWrapper.toolOut.println("2"); // Transformations
			if (strategyTransfType.equals("Lucas'")) {
				config.mutermWrapper.toolOut.println("1");
			} else if (strategyTransfType.equals("Zantema's")) {
				config.mutermWrapper.toolOut.println("2");
			} else if (strategyTransfType.equals("Ferreira and Ribeiro's")) {
				config.mutermWrapper.toolOut.println("3");
			} else if (strategyTransfType.equals("Giesl and Middeldorp's")) {
				config.mutermWrapper.toolOut.println("4");
			}
			config.mutermWrapper.toolOut.println("+");
			config.mutermWrapper.toolOut.println("0"); // Back
			config.mutermWrapper.toolOut.println("0"); // Back
			config.mutermWrapper.toolOut.println("1"); // File
			config.mutermWrapper.toolOut.println("3"); // Save as...
			config.mutermWrapper.toolOut.println("9"); // Set current TRS
			config.mutermWrapper.toolOut.println("1");
			config.mutermWrapper.toolOut.println("0"); // Back
			config.mutermWrapper.toolOut.println("0"); // Back
		}
	}
	
	protected void loadOutMaudeinMuterm() throws IOException{
		// MU-TERM can only interact via files
		// We create an intermediate file with the spec
		PrintWriter pw = new PrintWriter(
				               new FileWriter(config.MUTERM_INPUT_FILE));
		pw.println(command);
		pw.close();
		// we load the file into MU-TERM
		config.mutermWrapper.toolOut.println("1"); // File...
		config.mutermWrapper.toolOut.println("2"); // Load TRS in simple Maude/OBJ format
		config.mutermWrapper.toolOut.println(config.MUTERM_INPUT_FILE.getAbsolutePath());
		config.mutermWrapper.toolOut.println("y");
		config.mutermWrapper.toolOut.println();
		config.mutermWrapper.toolOut.println("0"); // Back
	}
	
	protected String getCommandMaude() throws InterruptedException{
		String command = config.maudeOutputListener.getCommand();

		for (int counter = 0; command == null && counter < 10; counter++) {
			Thread.sleep(100);
			command = config.maudeOutputListener.getCommand();
		}
		return command;
	}

	public void actionPerformed(ActionEvent e) {
		String action = e.getActionCommand();
		try {
			if (action.equals("check termination")) {
				gui.cleanAproveOutputText();
				gui.cleanCiMEOutputText();
				gui.cleanMaudeOutputText();
				gui.cleanMuTermOutputText();

				// Send to Maude the specification 
				String maudeSpec = gui.getMaudeInputText();
				config.maudeWrapper.toolOut.println(maudeSpec);
				
				if (MTT.DEBUG)
					System.out.println("MAUDE COMMAND: " + maudeSpec);

				// selected tool (0 CiME, 1 MuTerm, 2 AProVE)
				int selectedIndex = gui.terminationTool.getSelectedIndex();

				// we first send the result to MU-TERM 
				config.maudeWrapper.toolOut.println("(MU-TERM " + maudeTransfType 
						+ (gui.andOptimization() ? "" : " and-optimization off") + " .)");	
				command = getCommandMaude();
				if (command != null) {
					loadOutMaudeinMuterm();
					if (MTT.DEBUG) 
						System.out.println("Text sent to MU-TERM:" + command);
					// transformation to remove the strategy annotations
					doTransformation(command);
					if (selectedIndex == 1) { // MuTerm
						if (MTT.DEBUG) 
							System.out.println("Using Muterm for termination check");
						config.mutermWrapper.toolOut.println("5"); // Termination...
						config.mutermWrapper.toolOut.println("1"); // Polynomial termination...
						if (criterionTermMuTerm.equals("linearMuTerm")) {
							config.mutermWrapper.toolOut.println("3"); // Solve with CiME (linear interpretation)
						} else {
							config.mutermWrapper.toolOut.println("6"); // Solve with CiME (simple-mixed interpretation)
						}
						config.mutermWrapper.toolOut.println("0");
						config.mutermWrapper.toolOut.println("0");
					} else {
						if (MTT.DEBUG) 
							System.out.println("Using CiME or AProVE for termination check");
						config.mutermWrapper.toolOut.println("1"); // File
						config.mutermWrapper.toolOut.println("3"); // Save as...
						// create a file with the transformed spec
						if (selectedIndex == 0) {
							config.mutermWrapper.toolOut.println("4");  // CiME
						} else {
							config.mutermWrapper.toolOut.println("3");  // AProVE
						}
						config.mutermWrapper.toolOut.println(config.MUTERM_OUTPUT_FILE.getAbsolutePath());
						config.mutermWrapper.toolOut.println("y");
						// Go back to the top menu for succesive interactions
						config.mutermWrapper.toolOut.println("0");
						config.mutermWrapper.toolOut.println("0");
						if (selectedIndex == 0) { // CiME 
							// Read file generated by MuTerm
							command = "";
							while (!config.MUTERM_OUTPUT_FILE.exists()) {
								Thread.sleep(500);
							}
							String line = null;
							String lineLast = "";
							// The file exists, we start reading.
							while (!lineLast.equals("\";")) {
								if (!lineLast.equals("")) { // No sleep the first time.
									Thread.sleep(500);
								}
								BufferedReader file = new BufferedReader(
										new FileReader(config.MUTERM_OUTPUT_FILE)); 
								// Open again to get the modifications
								// Skip characters that were readed
								file.skip(command.length()); 
								line = file.readLine();
								while (line != null) { // read the new lines
									command += line.replace('_', 'o') + "\n";
									lineLast = line;
									line = file.readLine();
								}
								file.close();
							}
							
							// Do termination
							if (criterion.equals("minimal")) {
								command = command.replaceFirst("= TRS", "= HTRS {}");
							}
							config.cimeWrapper.toolOut.println(command);
							config.cimeWrapper.toolOut.println("termcrit \"" + criterion + "\" ;");
							config.cimeWrapper.toolOut.println("polyinterpkind " + createPolyInterp() + " ;");
							if (criterion.equals("minimal")) {
								config.cimeWrapper.toolOut.println("h_termination " + findName(command) + " ;");
							} else {
								config.cimeWrapper.toolOut.println("termination "+ findName(command) + " ;");
							}
						} else { // selectedIndex == 2  AProVE
							while (!config.MUTERM_OUTPUT_FILE.exists()) {
								if (MTT.DEBUG)
									System.out.println("waiting while getting the output from MuTerm"); 
								Thread.sleep(500);
							}

							Thread.sleep(500);
							
							this.executeAProVE();
							
// I cannot give exec permissions to it
//							if (!config.runAProVEFile.exists()) {
//								try {
//									PrintWriter file = new PrintWriter(new FileWriter(config.runAProVEFile));
//						            file.println("java -jar $1 -u cli -t $2 -p plain $3 > $4");
//						            file.close();
//						        } catch (IOException ioe) {
//						            System.out.println("The file " + config.runAProVEFile + " cannot be opened.");
//						            if (MTT.DEBUG) {
//						                ioe.printStackTrace();
//						            }
//						        }
//							}

//							if (MTT.DEBUG)
//								System.out.println(
//									"executing: " 
//									+ config.runAProVEFile.getAbsolutePath()  
//									+ " " + config.localAprove 
//									+ " " + gui.timeoutAProVE()
//									+ " " + config.MUTERM_OUTPUT_FILE.getAbsolutePath()
//									+ " " + config.AProVE_OUTPUT_FILE.getAbsolutePath());
//							Process aprove 
//								= Runtime.getRuntime().exec(
//									config.runAProVEFile.getAbsolutePath()  
//									+ " " + config.localAprove 
//									+ " " + gui.timeoutAProVE()
//									+ " " + config.MUTERM_OUTPUT_FILE.getAbsolutePath()
//									+ " " + config.AProVE_OUTPUT_FILE.getAbsolutePath());
//
//							aprove.waitFor();
//							
//							if (MTT.DEBUG)
//								System.out.println("back from: " 
//									+ config.runAProVEFile.getAbsolutePath()  
//									+ " " + config.localAprove 
//									+ " " + gui.timeoutAProVE()
//									+ " " + config.MUTERM_OUTPUT_FILE.getAbsolutePath()
//									+ " " + config.AProVE_OUTPUT_FILE.getAbsolutePath());
//							
//							// Read file generated by AProVE
//							BufferedReader file = new BufferedReader(
//								new FileReader(config.AProVE_OUTPUT_FILE)); 
//							String line = file.readLine();
//							while (line != null) {
//								gui.printAproveOutputText(line.replace('_', 'o') + "\n");
//								line = file.readLine();
//							}
//							file.close();
//							config.AProVE_OUTPUT_FILE.delete();
						}
						config.MUTERM_OUTPUT_FILE.delete();
					}
				} else {
					gui.printErrorMessage("Maude has not given the output on time.");
				}
			} else if (action.equals("complete") || action.equals("no sorts")
					|| action.equals("no kinds")) {
				maudeTransfType = action;
			} else if (action.equals("standard") || action.equals("minimal")
					|| action.equals("dp")) {
				criterion = action;
			} else if (action.equals("simple")) {
				SimpleInterpr = !SimpleInterpr;
				maxCoeffSimple = gui.getMaxCoeffSimple();
			} else if (action.equals("simple-mixed")) {
				SimpleMixedInterpr = !SimpleMixedInterpr;
				maxCoeffSimpleMixed = gui.getMaxCoeffSimpleMixed();
			} else if (action.equals("linear")) {
				LinearInterpr = !LinearInterpr;
				maxCoeffLinear = gui.getMaxCoeffLinear();
			} else if (action.equals("strategy")) {
				JComboBox cb = (JComboBox) e.getSource();
				strategyTransfType = (String) cb.getSelectedItem();
			} else if (action.equals("linearMuTerm")) {
				criterionTermMuTerm = action;
			} else if (action.equals("simple-mixedMuTerm")) {
				criterionTermMuTerm = action;
//			} else if (action.equals("CiME")) {
//				if (!config.isnotACime) {
//					gui.terminationTool.setEnabledAt(0, true);
//					gui.terminationTool.setSelectedIndex(0);
//					gui.terminationTool.setEnabledAt(1, false);
//					gui.terminationTool.setEnabledAt(2, false);
//				}
//			} else if (action.equals("MuTerm")) {
//				if (!config.isnotAMuTerm) {
//					gui.terminationTool.setEnabledAt(1, true);
//					gui.terminationTool.setSelectedIndex(1);
//					gui.terminationTool.setEnabledAt(0, false);
//					gui.terminationTool.setEnabledAt(2, false);
//				}
//			} else if (action.equals("Aprove")) {
//				if (!config.isnotAAprove) {
//					gui.terminationTool.setEnabledAt(2, true);
//					gui.terminationTool.setSelectedIndex(2);
//					gui.terminationTool.setEnabledAt(0, false);
//					gui.terminationTool.setEnabledAt(1, false);
//				}
//				gui.terminationTool.setEnabledAt(2, true);
//				gui.terminationTool.setSelectedIndex(2);
//				gui.terminationTool.setEnabledAt(0, false);
//				gui.terminationTool.setEnabledAt(1, false);
			} else if (action.equals("preferences")) {
				boolean ok = false;
				ConfigMTTDialog cdialog = new ConfigMTTDialog(gui, config);
				while (!ok) {
					cdialog.openDialog();
					ok = true;
					if (cdialog.OK) {
						config.save();
						try {

							/*
							 * if(ConfigMTTDialog.cambiaCiME||!config.isnotACime){
							 * config.closeConnectionCiME();
							 * config.establishConnectionCiME(gui); }
							 */
							if (ConfigMTTDialog.cambiaMaude) {
								config.closeConnectionMaude();
								config.establishConnectionMaude(gui);
							}
							/*
							 * if(ConfigMTTDialog.cambiaMuTerm||!config.isnotAMuTerm){
							 * config.closeConnectionMuTerm();
							 * config.establishConnectionMuTerm(gui); }
							 */

						} catch (UnknownHostException uhe) {
							ok = false;
							gui.printErrorMessage(uhe.getMessage());
							if (MTT.DEBUG) {
								System.out.println("Unknown host: "
										+ uhe.getMessage());
							}
						} catch (IOException ioe) {
							ok = false;
							gui.printErrorMessage(ioe.getMessage());
							if (MTT.DEBUG) {
								System.out.println(ioe.getMessage());
							}
						}
					}
				}
			} else if (action.equals("stop")) {
				config.closeConnections();

			}
		} catch (IOException ioe) {
			gui.printErrorMessage("Error in the interaction with the tools.");
			if (MTT.DEBUG) {
				ioe.printStackTrace();
			}
		} catch (InterruptedException ex) {
			gui.printErrorMessage("Error in the interaction with the tools.");
			if (MTT.DEBUG) {
				ex.printStackTrace();
			}
		} catch (NumberFormatException nfe) {
			gui.printErrorMessage("Error in the interaction with the tools.");
			if (MTT.DEBUG) {
				nfe.printStackTrace();
			}
		}
	}

	protected void executeAProVE() throws IOException { 
		// We first look for java.exe 
		String exe = System.getProperty("java.home") + File.separator + "bin" + File.separator;
		String arch = System.getProperty("os.arch");
	    if (arch.equals("sparcv9")) {
	        exe += "sparcv9/java";
	    } else {
	        exe += "java";
	    }

	    ProcessBuilder pb 
	    	= new ProcessBuilder(
	    			exe, 
	    			"-jar", 
	    			config.localAprove,
	    			"-u", "cli",
	    			"-t", (new Integer(gui.timeoutAProVE())).toString(),
	    			"-p", "plain",
	    			config.MUTERM_OUTPUT_FILE.getAbsolutePath());
	    Process pAProVE = pb.start();
	    
	    // Read file generated by AProVE
	    BufferedInputStream stream = new BufferedInputStream(pAProVE.getInputStream());
	    int c = stream.read();
		while (c != -1) {
			gui.printAproveOutputText((new Character((char)c == '_' ? 'o' : (char) c)).toString());
			c = stream.read();
		}
	    stream.close();
	}

	public void finalize() {
		try {
			if (MTT.DEBUG) {
				System.out.println("CtrlMTT finalizes");
			}
			config.closeConnections();
		} catch (IOException e) {
			if (MTT.DEBUG) {
				e.printStackTrace();
			}
		}
	}
}