import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

/**
 * SocketListener implements a thread that writes on a text area (output) the
 * characters that come from a socket.
 */
abstract class Listener extends Thread {
	protected final Reader in;

	protected final GUIMTT gui;

	public static final int BUFFER_SIZE = 2048;

	/**
	 * Flag used to indicate that we are shutting down (and that therefore an
	 * IOException is expected).
	 */
	private boolean inShutdown;

	Listener(GUIMTT gui, InputStream in) {
		this.in = new InputStreamReader(in);
		this.gui = gui;
		setPriority(Thread.MAX_PRIORITY - 1);
	}

	/**
	 * Shutdown this thread (by closing the socket and then waiting for the
	 * thread to terminate).
	 * 
	 * @param s
	 *            socket to close, must be the same that the input stream of
	 *            this SocketListener was derived from
	 * @throws IOException
	 */
	void doJoin() throws IOException {
		inShutdown = true;
		try {
			this.join(); // wait for thread to exit
		} catch (InterruptedException ie) {
			System.out.println("Error during termination " + ie);
			if (MTT.DEBUG)
				ie.printStackTrace();
		}
	}

	abstract void printOutputText(String s);

	public void run() {
		try {
			char[] cbuf = new char[BUFFER_SIZE];
			int count;
			while ((count = in.read(cbuf, 0, BUFFER_SIZE)) >= 0) {
				final StringBuffer ss = new StringBuffer(count);
				ss.append(cbuf, 0, count);
				printOutputText(ss.toString());
			}
			if (MTT.DEBUG)
				System.err.println("(Listener.printOutputText) read returned " + count
						+ " (this should never happen).");
		} catch (IOException e) {
			if (!inShutdown) {
				System.out.println("Error listening" + e);
				if (MTT.DEBUG)
					e.printStackTrace();
			}
		}
	}
}
