
import java.io.*;

/**
 * A wrapper object runs an application.
 */
class Wrapper {

	protected InputStream toolIn, toolError;
	protected PrintWriter toolOut;
	private String toolLocation;
	private Process toolProcess = null;

	public Wrapper(String path) throws IOException {
		toolLocation = path;

		// start the tool process
		if (MTT.DEBUG)
			System.out.println(path);
		toolProcess = Runtime.getRuntime().exec(path);

		// communication with the tool process
		toolIn = toolProcess.getInputStream();
		toolError = toolProcess.getErrorStream();
		toolOut = new PrintWriter(toolProcess.getOutputStream(), true);
	}

	public void finalize() {
		if (MTT.DEBUG)
			System.out.println(toolLocation + " (wrapper) dies!");
	}
}
