/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class GUIMTT
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 7103882705545906169L;
    private JButton checkButton;
    private JTextArea maudeInputText;
    private JTextArea maudeOutputText;
    private JTextArea cimeOutputText;
    private JTextArea mutermOutputText;
    private JTextArea errorOutputText;
    private JTextArea aproveOutputText;
    private JRadioButton rbStandard;
    private JRadioButton rbMinimal;
    private JRadioButton rbDependencyPair;
    private JRadioButton rbComplete;
    private JRadioButton rbSorts;
    private JRadioButton rbKinds;
    private JRadioButton rbLineal;
    private JRadioButton rbSimpleMixed;
    private JCheckBox cbLinear;
    private JCheckBox cbSimple;
    private JCheckBox cbSimpleMixed;
    private JTextField tfMaxCoeffLinear;
    private JTextField tfMaxCoeffSimple;
    private JTextField tfMaxCoeffSimpleMixed;
    private JTextField JTFTimeout;
    private JComboBox strategyTransfor;
    private JMenuItem preferences;
    protected JTabbedPane outTabbed;
    protected JTabbedPane terminationTool;
    private JCheckBox andOptimization;

    public GUIMTT(Configuration config) {
        super("MTT (The Maude Termination Tool)");
        this.setDefaultCloseOperation(3);
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        menuFile.setMnemonic(70);
        menuBar.add(menuFile);
        menuFile.addSeparator();
        JMenuItem openFile = new JMenuItem("Open file...");
        openFile.setMnemonic(79);
        openFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        openFile.addActionListener(new OpenL());
        menuFile.add(openFile);
        JMenuItem saveFile = new JMenuItem("Save file...");
        saveFile.setMnemonic(83);
        saveFile.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        saveFile.addActionListener(new SaveL());
        menuFile.add(saveFile);
        menuFile.addSeparator();
        JMenu menuEdit = new JMenu("Edit");
        menuEdit.setMnemonic(69);
        menuBar.add(menuEdit);
        menuEdit.addSeparator();
        this.preferences = new JMenuItem("Preferences...");
        this.preferences.setMnemonic(83);
        menuEdit.add(this.preferences);
        this.setJMenuBar(menuBar);
        JPanel optionPanel = new JPanel(new BorderLayout());
        this.rbComplete = new JRadioButton("Complete", true);
        this.rbSorts = new JRadioButton("No Sorts");
        this.rbKinds = new JRadioButton("No Kinds");
        ButtonGroup bgSortCondTransf = new ButtonGroup();
        bgSortCondTransf.add(this.rbComplete);
        bgSortCondTransf.add(this.rbSorts);
        bgSortCondTransf.add(this.rbKinds);
        JPanel typingPanelButton = new JPanel(new FlowLayout());
        typingPanelButton.add(this.rbComplete);
        typingPanelButton.add(this.rbKinds);
        typingPanelButton.add(this.rbSorts);
        this.andOptimization = new JCheckBox("AND optimization", true);
        String[] typeStrategy = new String[]{"Eliminate CS information", "Lucas'", "Zantema's", "Ferreira and Ribeiro's", "Giesl and Middeldorp's"};
        this.strategyTransfor = new JComboBox<String>(typeStrategy);
        this.strategyTransfor.setSelectedIndex(0);
        JPanel stratTransfPanel = new JPanel(new FlowLayout());
        stratTransfPanel.add(new JLabel("CS-TRS Transf.: "));
        stratTransfPanel.add(this.strategyTransfor);
        JPanel typingPanel = new JPanel(new GridLayout(4, 1));
        typingPanel.add(new JLabel("Typing desugaring"));
        typingPanel.add(typingPanelButton);
        typingPanel.add(this.andOptimization);
        typingPanel.add(stratTransfPanel);
        optionPanel.add((Component)typingPanel, "North");
        this.checkButton = new JButton("Check");
        JPanel stratTransfPanelCheck = new JPanel(new GridLayout(0, 1));
        stratTransfPanelCheck.add(this.checkButton);
        optionPanel.add((Component)stratTransfPanelCheck, "South");
        this.terminationTool = new JTabbedPane(1, 1);
        JPanel optionCiMEPanel = new JPanel(new GridLayout(0, 1));
        optionCiMEPanel.add(new JLabel("Termination criterion"));
        this.rbStandard = new JRadioButton("Standard");
        optionCiMEPanel.add(this.rbStandard);
        this.rbMinimal = new JRadioButton("Minimal", true);
        optionCiMEPanel.add(this.rbMinimal);
        this.rbDependencyPair = new JRadioButton("Dependency pairs", true);
        optionCiMEPanel.add(this.rbDependencyPair);
        ButtonGroup bgCriterion = new ButtonGroup();
        bgCriterion.add(this.rbStandard);
        bgCriterion.add(this.rbMinimal);
        bgCriterion.add(this.rbDependencyPair);
        optionCiMEPanel.add(new JLabel("Polynomial Interpretation"));
        JPanel polyPanelLinear = new JPanel(new FlowLayout(0));
        this.cbLinear = new JCheckBox("Linear", true);
        polyPanelLinear.add(this.cbLinear);
        this.tfMaxCoeffLinear = new JTextField("2", 3);
        this.tfMaxCoeffLinear.setHorizontalAlignment(0);
        polyPanelLinear.add(this.tfMaxCoeffLinear);
        optionCiMEPanel.add(polyPanelLinear);
        JPanel polyPanelSimpleMixed = new JPanel(new FlowLayout(0));
        this.cbSimpleMixed = new JCheckBox("Simple-Mixed", true);
        polyPanelSimpleMixed.add(this.cbSimpleMixed);
        this.tfMaxCoeffSimpleMixed = new JTextField("6", 3);
        this.tfMaxCoeffSimpleMixed.setHorizontalAlignment(0);
        polyPanelSimpleMixed.add(this.tfMaxCoeffSimpleMixed);
        optionCiMEPanel.add(polyPanelSimpleMixed);
        JPanel polyPanelSimple = new JPanel(new FlowLayout(0));
        this.cbSimple = new JCheckBox("Simple", false);
        polyPanelSimple.add(this.cbSimple);
        this.tfMaxCoeffSimple = new JTextField(3);
        this.tfMaxCoeffSimple.setHorizontalAlignment(0);
        polyPanelSimple.add(this.tfMaxCoeffSimple);
        optionCiMEPanel.add(polyPanelSimple);
        this.cimeOutputText = new JTextArea(10, 20);
        JScrollPane cimeOutputPanel = new JScrollPane(this.cimeOutputText);
        JPanel panelCiME = new JPanel(new BorderLayout());
        panelCiME.add((Component)optionCiMEPanel, "Center");
        this.rbLineal = new JRadioButton("Linear", true);
        this.rbSimpleMixed = new JRadioButton("Simple-Mixed");
        JPanel option = new JPanel(new GridLayout(2, 1));
        option.add(this.rbLineal);
        option.add(this.rbSimpleMixed);
        ButtonGroup bgoptionMuterm = new ButtonGroup();
        bgoptionMuterm.add(this.rbLineal);
        bgoptionMuterm.add(this.rbSimpleMixed);
        JPanel optionMutermPanel = new JPanel(new FlowLayout());
        optionMutermPanel.add(option);
        JPanel optionAProVEPanel = new JPanel(new GridLayout(2, 1));
        JCheckBox conditionsForAProVE = new JCheckBox("AProVE handles conditions", false);
        conditionsForAProVE.setEnabled(false);
        this.JTFTimeout = new JTextField("30", 3);
        this.JTFTimeout.setHorizontalAlignment(0);
        JPanel JPTimeout = new JPanel(new FlowLayout(0));
        JPTimeout.add(new JLabel("Timeout: "));
        JPTimeout.add(this.JTFTimeout);
        JPTimeout.add(new JLabel(" seconds"));
        optionAProVEPanel.add(conditionsForAProVE);
        optionAProVEPanel.add(JPTimeout);
        this.terminationTool.add("CiME", optionCiMEPanel);
        this.terminationTool.addTab("MU-TERM", optionMutermPanel);
        this.terminationTool.addTab("AProVE", optionAProVEPanel);
        optionPanel.add((Component)this.terminationTool, "Center");
        JPanel inputMaude = new JPanel(new BorderLayout());
        JPanel labelMaude = new JPanel(new FlowLayout());
        JLabel inputMaudeLabel = new JLabel("InputText Maude");
        labelMaude.add(inputMaudeLabel);
        this.maudeInputText = new JTextArea(30, 33);
        JScrollPane maudeInputPanel = new JScrollPane(this.maudeInputText);
        inputMaude.add((Component)labelMaude, "Center");
        inputMaude.add((Component)maudeInputPanel, "South");
        this.maudeOutputText = new JTextArea(10, 20);
        JScrollPane maudeOutputPanel = new JScrollPane(this.maudeOutputText);
        this.mutermOutputText = new JTextArea(10, 20);
        JScrollPane mutermOutputPanel = new JScrollPane(this.mutermOutputText);
        this.aproveOutputText = new JTextArea(10, 20);
        JScrollPane aproveOutputPanel = new JScrollPane(this.aproveOutputText);
        this.errorOutputText = new JTextArea(10, 20);
        JScrollPane errorOutputPanel = new JScrollPane(this.errorOutputText);
        this.outTabbed = new JTabbedPane(1, 1);
        this.outTabbed.addTab("CiME output", cimeOutputPanel);
        this.outTabbed.addTab("MU-TERM output", mutermOutputPanel);
        this.outTabbed.addTab("Maude output", maudeOutputPanel);
        this.outTabbed.addTab("AProVE output", aproveOutputPanel);
        this.outTabbed.addTab("Error messages", errorOutputPanel);
        Container container = this.getContentPane();
        container.add((Component)optionPanel, "West");
        container.add((Component)inputMaude, "Center");
        container.add((Component)this.outTabbed, "South");
        this.pack();
    }

    public void control(CtrlMTT ctrl) {
        this.checkButton.addActionListener(ctrl);
        this.checkButton.setActionCommand("check termination");
        this.rbComplete.addActionListener(ctrl);
        this.rbComplete.setActionCommand("complete");
        this.rbSorts.addActionListener(ctrl);
        this.rbSorts.setActionCommand("no sorts");
        this.rbKinds.addActionListener(ctrl);
        this.rbKinds.setActionCommand("no kinds");
        this.rbStandard.addActionListener(ctrl);
        this.rbStandard.setActionCommand("standard");
        this.rbMinimal.addActionListener(ctrl);
        this.rbMinimal.setActionCommand("minimal");
        this.rbDependencyPair.addActionListener(ctrl);
        this.rbDependencyPair.setActionCommand("dp");
        this.cbLinear.addActionListener(ctrl);
        this.cbLinear.setActionCommand("linear");
        this.cbSimple.addActionListener(ctrl);
        this.cbSimple.setActionCommand("simple");
        this.cbSimpleMixed.addActionListener(ctrl);
        this.cbSimpleMixed.setActionCommand("simple-mixed");
        this.strategyTransfor.addActionListener(ctrl);
        this.strategyTransfor.setActionCommand("strategy");
        this.preferences.setActionCommand("preferences");
        this.preferences.addActionListener(ctrl);
        this.rbLineal.addActionListener(ctrl);
        this.rbLineal.setActionCommand("linearMuTerm");
        this.rbSimpleMixed.addActionListener(ctrl);
        this.rbSimpleMixed.setActionCommand("simple-mixedMuTerm");
    }

    public void printMaudeText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.maudeInputText.setText(ss);
            }
        });
    }

    public String getMaudeInputText() {
        return this.maudeInputText.getText();
    }

    public void cleanMaudeText() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.maudeInputText.setText("");
            }
        });
    }

    public void printMaudeOutputText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.maudeOutputText.append(ss);
                GUIMTT.this.outTabbed.setSelectedIndex(2);
            }
        });
    }

    public String getMaudeOutputText() {
        return this.maudeOutputText.getText();
    }

    public void cleanMaudeOutputText() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.maudeOutputText.setText("");
            }
        });
    }

    public void cleanMuTermOutputText() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.mutermOutputText.setText("");
            }
        });
    }

    public void cleanCiMEOutputText() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.cimeOutputText.setText("");
            }
        });
    }

    public void printCimeOutputText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.cimeOutputText.append(ss);
                GUIMTT.this.outTabbed.setSelectedIndex(0);
            }
        });
    }

    public void cleanAproveOutputText() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.aproveOutputText.setText("");
            }
        });
    }

    public void printAproveOutputText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.aproveOutputText.append(ss);
                GUIMTT.this.outTabbed.setSelectedIndex(3);
            }
        });
    }

    public void printMutermOutputText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.mutermOutputText.append(ss);
                GUIMTT.this.outTabbed.setSelectedIndex(1);
            }
        });
    }

    public int getMaxCoeffLinear() {
        return Integer.parseInt(this.tfMaxCoeffLinear.getText());
    }

    public int getMaxCoeffSimple() {
        return Integer.parseInt(this.tfMaxCoeffSimple.getText());
    }

    public int getMaxCoeffSimpleMixed() {
        return Integer.parseInt(this.tfMaxCoeffSimpleMixed.getText());
    }

    public void printErrorMessage(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMTT.this.errorOutputText.setForeground(Color.RED);
                GUIMTT.this.errorOutputText.append(String.valueOf(ss) + "\n");
                GUIMTT.this.outTabbed.setSelectedIndex(4);
            }
        });
    }

    public boolean andOptimization() {
        return this.andOptimization.isSelected();
    }

    public int timeoutAProVE() throws NumberFormatException {
        return Integer.parseInt(this.JTFTimeout.getText());
    }

    public void run() {
        this.setVisible(true);
    }

    class OpenL
    implements ActionListener {
        OpenL() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser c = new JFileChooser();
            try {
                int rVal = c.showOpenDialog(GUIMTT.this);
                if (rVal == 0) {
                    BufferedReader file = new BufferedReader(new FileReader(String.valueOf(c.getCurrentDirectory().toString()) + "/" + c.getSelectedFile().getName()));
                    String text = "";
                    String line = file.readLine();
                    while (line != null) {
                        text = String.valueOf(text) + line + "\n";
                        line = file.readLine();
                    }
                    file.close();
                    GUIMTT.this.printMaudeText(text);
                }
            }
            catch (IOException ex) {
                System.out.println("IO error reading file " + c.getCurrentDirectory().toString() + "/" + c.getSelectedFile().getName());
            }
        }
    }

    class SaveL
    implements ActionListener {
        SaveL() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser c = new JFileChooser();
            try {
                int rVal = c.showSaveDialog(GUIMTT.this);
                if (rVal == 0) {
                    String text = GUIMTT.this.getMaudeInputText();
                    PrintWriter file = new PrintWriter(new FileWriter(String.valueOf(c.getCurrentDirectory().toString()) + "/" + c.getSelectedFile().getName()));
                    file.print(text);
                    file.close();
                }
            }
            catch (IOException ex) {
                System.out.println("IO error writing file " + c.getCurrentDirectory().toString() + "/" + c.getSelectedFile().getName());
            }
        }
    }
}

