import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.StringTokenizer;

public class Configuration {
    public File configFile = new File("MTT.cfg");

    public File MUTERM_INPUT_FILE = new File("MuTermInputFile.mtt");
    public File MUTERM_OUTPUT_FILE = new File("MuTermOutputFile.mtt");
    public File AProVE_OUTPUT_FILE = new File("AProVEOutputFile.mtt"); 

    public int portMaude = 60000;
    public int portMaudeLocal = 60000;
    public String urlMaude;
    public String localMaude = "maude";
    public String localFullMaude = "fullmaude";
    public String localMttTransf = "mtttransf";
    public boolean isServerMaude = false;    

    public int portCiME = 61000;
    public int portCiMELocal = 61000;
    public String urlCiME;
    public String localCiME = "cime";
    public boolean isServerCiME = false;
    public boolean isnotACime = false;
    public boolean CiMEnotAStarted = false;

    public int portMuTerm = 62000;
    public int portMuTermLocal = 62000;
    public String urlHaskell;
    public String localHaskell = "haskell";
    public boolean isServerMuTerm = false;
    public boolean isnotAMuTerm = false;
    public boolean MuTermnotAStarted = false;
    public String localMuTerm = "muterm";
    public String urlMuTerm;
    
    public boolean isnotAAprove = false;
    public boolean isServerAprove = false;
    public boolean AprovenotAStarted = false;
    public String localAprove = "aprove";
    public String urlAprove;
    public int portAprove = 63000;
    public int portAproveLocal = 63000;
    
    Wrapper cimeWrapper;
    Wrapper mutermWrapper;
    Wrapper maudeWrapper;
    Wrapper aproveWrapper;

    // CiME's socket
    protected Socket socketCiME = null;
    // Maude's socket
    protected Socket socketMaude = null;
    // MuTerm's socket
    protected Socket socketMuTerm = null;
    // threads that write on the text areas
    protected MaudeListener maudeOutputListener;
    protected CiMEListener cimeOutputListener;
    protected MuTermListener mutermOutputListener;
    protected AProVEListener aproveOutputListener;

    /**
     * @param gui
     * @throws IOException
     */
    public void establishConnections(GUIMTT gui) throws IOException {
        
        if(!CiMEnotAStarted){
        	if (isServerCiME) {
                if (MTT.DEBUG) {
                    System.out.println("isServerCiME");
                }
                socketCiME = new Socket(urlCiME, portCiME);
            } else {
                if (MTT.DEBUG) {
                    System.out.println("!isServerCiME");
                }
                //Conection with local tool
                cimeWrapper = new Wrapper(localCiME);
                cimeOutputListener = new CiMEListener(gui, cimeWrapper.toolIn);
                Thread cimeOutputThread = new Thread(cimeOutputListener, "CiME's output");
                cimeOutputThread.setPriority(Thread.NORM_PRIORITY);
                cimeOutputThread.start();
            }
        }    	
        if (isServerMaude) {
            if (MTT.DEBUG) {
                System.out.println("isServerMaude");
            }
            socketMaude = new Socket(urlMaude, portMaude);
        } else {
            if (MTT.DEBUG) {
                System.out.println("!isServerMaude");
            }
            //Conection with local tool
             maudeWrapper 
             	= new Wrapper(localMaude + " " + localFullMaude + " " + localMttTransf);
             maudeOutputListener = new MaudeListener(gui, maudeWrapper.toolIn);
             Thread maudeBufferThread = new Thread(maudeOutputListener,
                                                   "maude's output");
             maudeBufferThread.setPriority(Thread.NORM_PRIORITY);
             maudeBufferThread.start();
        } 
        if(!MuTermnotAStarted){
        	if (isServerMuTerm) {
                if (MTT.DEBUG) {
                    System.out.println("isServerMuTerm");
                }
                socketMuTerm = new Socket(urlMuTerm, portMuTerm);
            } else {
                if (MTT.DEBUG) {
                    System.out.println("!isServerMuTerm");
                }
                //Conection with local tool
                mutermWrapper = new MuTermWrapper(localHaskell, localMuTerm);
                mutermOutputListener = new MuTermListener(gui, mutermWrapper.toolIn);
                Thread mutermOutputThread = new Thread(mutermOutputListener, "MuTerm's output");
                mutermOutputThread.setPriority(Thread.NORM_PRIORITY);
                mutermOutputThread.start();  		        
            }
        }
    }
    
    public void establishConnectionCiME(GUIMTT gui) throws IOException {
        
    	if(!CiMEnotAStarted){
    		if (isServerCiME) {
                if (MTT.DEBUG) {
                    System.out.println("isServerCiME");
                }
                socketCiME = new Socket(urlCiME, portCiME);
            } else {
                if (MTT.DEBUG) {
                    System.out.println("!isServerCiME");
                }
                //Conection with local tool
                cimeWrapper = new Wrapper(localCiME);
            }
            cimeOutputListener = new CiMEListener(gui, cimeWrapper.toolIn);
            Thread cimeOutputThread = new Thread(cimeOutputListener, "CiME's output");
            cimeOutputThread.setPriority(Thread.NORM_PRIORITY);
            cimeOutputThread.start();
    	}
    }

    public void establishConnectionMaude(GUIMTT gui) throws IOException {
    	if (isServerMaude) {
    		if (MTT.DEBUG) {
    			System.out.println("isServerMaude");
    		}
    		socketMaude = new Socket(urlMaude, portMaude);
    	} else {
    		if (MTT.DEBUG) {
    			System.out.println("!isServerMaude");
    		}
    		//Conection with local tool
    		maudeWrapper 
    			= new Wrapper(localMaude + " " + localFullMaude + " " + localMttTransf);
    	}
    	 maudeOutputListener = new MaudeListener(gui, maudeWrapper.toolIn);
         Thread maudeBufferThread = new Thread(maudeOutputListener, "Maude's output");
         maudeBufferThread.setPriority(Thread.NORM_PRIORITY);
         maudeBufferThread.start();
    }
    
    public void establishConnectionMuTerm(GUIMTT gui) throws IOException {
    	
    	if(!MuTermnotAStarted){
    		if (isServerMuTerm) {
                if (MTT.DEBUG) {
                    System.out.println("isServerMuTerm");
                }
                socketMuTerm = new Socket(urlMuTerm, portMuTerm);
            } else {
                if (MTT.DEBUG) {
                    System.out.println("!isServerMuTerm");
                }
                //Conection with local tool
    			 mutermWrapper = new MuTermWrapper(localHaskell, localMuTerm);
            }
        	mutermOutputListener = new MuTermListener(gui, mutermWrapper.toolIn);
            Thread mutermOutputThread = new Thread(mutermOutputListener, "MuTerm's output");
            mutermOutputThread.setPriority(Thread.NORM_PRIORITY);
            mutermOutputThread.start();
    	}
    }	
    
    public void closeConnectionCiME(GUIMTT gui) throws IOException {
    	if (MTT.DEBUG) System.out.println("Closing connections.");
        cimeOutputListener.doJoin();
        gui.cleanCiMEOutputText();
        if (MTT.DEBUG) System.out.println("Done closing connections.");        
    }
    
    public void closeConnectionMaude() throws IOException {
    	if (MTT.DEBUG) System.out.println("Closing connections.");
        maudeOutputListener.doJoin();
        if (MTT.DEBUG) System.out.println("Done closing connections.");        
    }
    
    public void closeConnectionMuTerm(GUIMTT gui) throws IOException {
    	if (MTT.DEBUG) System.out.println("Closing connections.");
        mutermOutputListener.doJoin();
        gui.cleanMuTermOutputText();
        if (MTT.DEBUG) System.out.println("Done closing connections.");        
    }
    
    public void closeConnections() throws IOException {
    	if (MTT.DEBUG) System.out.println("Closing connections.");
    	maudeOutputListener.doJoin();
    	cimeOutputListener.doJoin();
        mutermOutputListener.doJoin();
        if (MTT.DEBUG) System.out.println("Done closing connections.");        
    }

    public void save() {
        try {
            PrintWriter file = new PrintWriter(new FileWriter(configFile));
            file.println("isServerMaude=" + isServerMaude);
            file.println("portMaude=" + portMaude);
            file.println("portMaudeLocal=" + portMaudeLocal);
            file.println("urlMaude=" + urlMaude);
            file.println("localMaude=" + localMaude);
            file.println("localFullMaude=" + localFullMaude);
            file.println("localMttTransf=" + localMttTransf);

            file.println("isServerCiME=" + isServerCiME);
            file.println("isnotACime=" + isnotACime);
            file.println("CiMEnotAStarted=" + CiMEnotAStarted);
            file.println("portCiME=" + portCiME);
            file.println("portCiMELocal=" + portCiMELocal);
            file.println("urlCiME=" + urlCiME);
            file.println("localCiME=" + localCiME);
            
            file.println("isServerAprove=" + isServerAprove);
            file.println("isnotAAprove=" + isnotAAprove);
            file.println("AprovenotAStarted=" + AprovenotAStarted);
            file.println("portAprove=" + portAprove);
            file.println("portAproveLocal=" + portAproveLocal);
            file.println("urlAprove=" + urlAprove);
            file.println("localAprove=" + localAprove);

            file.println("isServerMuTerm=" + isServerMuTerm);
            file.println("isnotAMuTerm=" + isnotAMuTerm);
            file.println("MuTermnotAStarted=" + MuTermnotAStarted);            
            file.println("portHaskell=" + portMuTerm);
            file.println("portHaskellLocal=" + portMuTermLocal);
            file.println("urlHaskell=" + urlHaskell);
            file.println("localHaskell=" + localHaskell);
            file.println("localMuTerm=" + localMuTerm);
            file.close();
        } catch (IOException ioe) {
            System.out.println("The file " + configFile + " cannot be opened.");
            if (MTT.DEBUG) {
                ioe.printStackTrace();
            }
        }
    }

    public void load() throws IOException {
    	try {
	        BufferedReader file = new BufferedReader(new FileReader(configFile));
	        StringTokenizer st;
	
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("isServerMaude")) {
	            isServerMaude = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("portMaude")) {
	            portMaude = Integer.parseInt(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("portMaudeLocal")) {
	            portMaudeLocal = Integer.parseInt(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("urlMaude")) {
	            urlMaude = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("localMaude")) {
	            localMaude = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("localFullMaude")) {
	            localFullMaude = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("localMttTransf")) {
	            localMttTransf = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("isServerCiME")) {
	            isServerCiME = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("isnotACime")) {
	        	isnotACime = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("CiMEnotAStarted")) {
	        	CiMEnotAStarted = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("portCiME")) {
	            portCiME = Integer.parseInt(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("portCiMELocal")) {
	            portCiMELocal = Integer.parseInt(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("urlCiME")) {
	            urlCiME = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("localCiME")) {
	            localCiME = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("isServerAprove")) {
	            isServerAprove = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("isnotAAprove")) {
	        	isnotAAprove = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("AprovenotAStarted")) {
	        	AprovenotAStarted = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("portAprove")) {
	            portAprove = Integer.parseInt(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("portAproveLocal")) {
	            portAproveLocal = Integer.parseInt(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("urlAprove")) {
	            urlAprove = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("localAprove")) {
	            localAprove = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("isServerMuTerm")) {
	            isServerMuTerm = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("isnotAMuTerm")) {
	        	isnotAMuTerm = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("MuTermnotAStarted")) {
	        	MuTermnotAStarted = Boolean.parseBoolean(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("portHaskell")) {
	            portMuTerm = Integer.parseInt(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("portHaskellLocal")) {
	            portMuTermLocal = Integer.parseInt(st.nextToken());
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("urlHaskell")) {
	            urlHaskell = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("localHaskell")) {
	            localHaskell = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        st = new StringTokenizer(file.readLine(), "=");
	        if (st.countTokens() == 2 && st.nextToken().equals("localMuTerm")) {
	            localMuTerm = st.nextToken();
	        } else {
	            throw new IOException("Error reading file " + configFile);
	        }
	        file.close();
    	} catch (NumberFormatException e) {
    		throw new IOException("Error reading file " + configFile);
	    } catch (NullPointerException e) {
	    	throw new IOException("Error reading file " + configFile);
	    }
    }
}

