/**
 * The class does the graphic interface of the application.
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class GUIMTT extends JFrame implements Runnable {

	private static final long serialVersionUID = 7103882705545906169L;
	private JButton checkButton; //, initButton;
    private JTextArea maudeInputText, maudeOutputText, cimeOutputText,
            mutermOutputText, errorOutputText, aproveOutputText;
    private JRadioButton rbStandard, rbMinimal, rbDependencyPair,
            rbComplete, rbSorts, rbKinds,rbLineal,rbSimpleMixed;
    private JCheckBox cbLinear, cbSimple, cbSimpleMixed;
    private JTextField tfMaxCoeffLinear, tfMaxCoeffSimple,
            tfMaxCoeffSimpleMixed, JTFTimeout;
    private JComboBox strategyTransfor;
    private JMenuItem preferences;
//    protected JRadioButton rbCiME,rbMuTerm,rbAprove;
    protected JTabbedPane outTabbed,terminationTool;
    private JCheckBox andOptimization;
	
    public GUIMTT(Configuration config) {
        //Create and set up the window.
        super("MTT (The Maude Termination Tool)");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        /**Create the menu bar.*/
        JMenuBar menuBar = new JMenuBar();

        //Build the menu File
        JMenu menuFile = new JMenu("File");
        menuFile.setMnemonic(KeyEvent.VK_F);
        menuBar.add(menuFile);

        menuFile.addSeparator();
        JMenuItem openFile = new JMenuItem("Open file...");
        //openFile.setSelected(true);
        openFile.setMnemonic(KeyEvent.VK_O);
        openFile.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O,
                ActionEvent.CTRL_MASK));
        openFile.addActionListener(new OpenL());
        menuFile.add(openFile);

        JMenuItem saveFile = new JMenuItem("Save file...");
        saveFile.setMnemonic(KeyEvent.VK_S);
        saveFile.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        saveFile.addActionListener(new SaveL());
        menuFile.add(saveFile);

        menuFile.addSeparator();

        //JMenuItem saveFileConf = new JMenuItem("Save configuration file...");
        //saveFileConf.setMnemonic(KeyEvent.VK_C);
        //saveFileConf.addActionListener(new SaveConfigListener(config));
        //menuFile.add(saveFileConf);

        //Build the menu Edit
        JMenu menuEdit = new JMenu("Edit");
        menuEdit.setMnemonic(KeyEvent.VK_E);
        menuBar.add(menuEdit);

        menuEdit.addSeparator();
        preferences = new JMenuItem("Preferences...");
        preferences.setMnemonic(KeyEvent.VK_S);
        menuEdit.add(preferences);

        //Set JMenuBar to Frame
        this.setJMenuBar(menuBar);

        //Create the menu on the left-hand side

        JPanel optionPanel = new JPanel(new BorderLayout()); //1 columna e infinita filas

        // Typing-Conditions desugaring transformation

        

        rbComplete = new JRadioButton("Complete", true);
        //rbComplete.setMnemonic(KeyEvent.VK_C);//if you key ALT + C then the RadioButton "Complete" actives.
        //optionPanel.add(rbComplete);

        rbSorts = new JRadioButton("No Sorts");
        //rbSorts.setMnemonic(KeyEvent.VK_S);
        //optionPanel.add(rbSorts);

        rbKinds = new JRadioButton("No Kinds");
        //rbKinds.setMnemonic(KeyEvent.VK_K);
        //optionPanel.add(rbKinds);

        ButtonGroup bgSortCondTransf = new ButtonGroup();
        bgSortCondTransf.add(rbComplete);
        bgSortCondTransf.add(rbSorts);
        bgSortCondTransf.add(rbKinds);
        
//        rbCiME=new JRadioButton("CiME",true);
//        rbMuTerm=new JRadioButton("MuTerm");
//        rbAprove=new JRadioButton("Aprove");
//        ButtonGroup bgTermination= new ButtonGroup();
//        bgTermination.add(rbCiME);
//        bgTermination.add(rbMuTerm);
//        bgTermination.add(rbAprove);

        JPanel typingPanelButton= new JPanel(new FlowLayout());
        typingPanelButton.add(rbComplete);
        typingPanelButton.add(rbKinds);
        typingPanelButton.add(rbSorts);
        andOptimization = new JCheckBox("AND optimization", true);
        
        // Strategies
        String[] typeStrategy = {
                	"Eliminate CS information",
					"Lucas'",
					"Zantema's",
					"Ferreira and Ribeiro's",
                	"Giesl and Middeldorp's"};
        strategyTransfor = new JComboBox(typeStrategy);
        strategyTransfor.setSelectedIndex(0);
        JPanel stratTransfPanel = new JPanel(new FlowLayout());
        stratTransfPanel.add(new JLabel("CS-TRS Transf.: "));
        stratTransfPanel.add(strategyTransfor);

        JPanel typingPanel = new JPanel(new GridLayout(4, 1));
        typingPanel.add(new JLabel("Typing desugaring"));
        typingPanel.add(typingPanelButton);
        typingPanel.add(andOptimization);
        typingPanel.add(stratTransfPanel);
        
//        JPanel terminationPanel= new JPanel(new GridLayout(2,1));
//        terminationPanel.add(new JLabel("Tool Termination"));
//        JPanel terminationPanelButton=new JPanel(new FlowLayout());
//        terminationPanelButton.add(rbCiME);
//        terminationPanelButton.add(rbMuTerm);
//        terminationPanelButton.add(rbAprove);
//        terminationPanel.add(terminationPanelButton);
//        JPanel typingTermination = new JPanel(new GridLayout(2,1));
//        typingTermination.add(typingPanel);
//        typingTermination.add(terminationPanel);
//        optionPanel.add(typingTermination,BorderLayout.NORTH);
        optionPanel.add(typingPanel, BorderLayout.NORTH);
        
        // CHECK button

        checkButton = new JButton("Check");
        
        JPanel stratTransfPanelCheck = new JPanel(new GridLayout(0,1));
        stratTransfPanelCheck.add(checkButton);
        
        optionPanel.add(stratTransfPanelCheck,BorderLayout.SOUTH);
        //stopButton = new JButton("Stop");
        //initButton = new JButton("Init tools");
        //initButton.addActionListener(this);

        /*   JPanel panelButton = new JPanel();
           panelButton.add(checkButton);
           panelButton.add(initButton);
         */

              
        /*JPanel toolPanel = new JPanel();
        toolPanel.setLayout(new BorderLayout());
        toolPanel.add(optionPanel, BorderLayout.NORTH);
        //toolPanel.add(panelButton, BorderLayout.SOUTH);
        JPanel buttonPanel= new JPanel(new FlowLayout());
        buttonPanel.add(checkButton);
        buttonPanel.add(stopButton);
        toolPanel.add(buttonPanel,BorderLayout.CENTER);*/

        //Create select termination tool
        terminationTool = new JTabbedPane(JTabbedPane.TOP,
                						JTabbedPane.SCROLL_TAB_LAYOUT);
        
        	// OptionPanel Cime
        
        JPanel optionCiMEPanel = new JPanel(new GridLayout(0, 1));
        optionCiMEPanel.add(new JLabel("Termination criterion"));

        rbStandard = new JRadioButton("Standard");
        optionCiMEPanel.add(rbStandard);

        rbMinimal = new JRadioButton("Minimal", true);
        optionCiMEPanel.add(rbMinimal);

        rbDependencyPair = new JRadioButton("Dependency pairs", true);
        optionCiMEPanel.add(rbDependencyPair);

        ButtonGroup bgCriterion = new ButtonGroup();
        bgCriterion.add(rbStandard);
        bgCriterion.add(rbMinimal);
        bgCriterion.add(rbDependencyPair);

        // Polynomial interpretation

        optionCiMEPanel.add(new JLabel("Polynomial Interpretation"));

        JPanel polyPanelLinear = new JPanel(new FlowLayout(FlowLayout.LEFT));
        cbLinear = new JCheckBox("Linear", true);
        polyPanelLinear.add(cbLinear);
        tfMaxCoeffLinear = new JTextField("2", 3);
        tfMaxCoeffLinear.setHorizontalAlignment(JTextField.CENTER);
        polyPanelLinear.add(tfMaxCoeffLinear);
        optionCiMEPanel.add(polyPanelLinear);

        JPanel polyPanelSimpleMixed = new JPanel(new FlowLayout(FlowLayout.LEFT));
        cbSimpleMixed = new JCheckBox("Simple-Mixed", true);
        polyPanelSimpleMixed.add(cbSimpleMixed);
        tfMaxCoeffSimpleMixed = new JTextField("6", 3);
        tfMaxCoeffSimpleMixed.setHorizontalAlignment(JTextField.CENTER);
        polyPanelSimpleMixed.add(tfMaxCoeffSimpleMixed);
        optionCiMEPanel.add(polyPanelSimpleMixed);

        JPanel polyPanelSimple = new JPanel(new FlowLayout(FlowLayout.LEFT));
        cbSimple = new JCheckBox("Simple", false);
        polyPanelSimple.add(cbSimple);
        tfMaxCoeffSimple = new JTextField(3);
        tfMaxCoeffSimple.setHorizontalAlignment(JTextField.CENTER);
        polyPanelSimple.add(tfMaxCoeffSimple);
        optionCiMEPanel.add(polyPanelSimple);
        
        cimeOutputText = new JTextArea(10, 20);
        JScrollPane cimeOutputPanel = new JScrollPane(cimeOutputText);
        
        JPanel panelCiME=new JPanel(new BorderLayout());        
        panelCiME.add(optionCiMEPanel,BorderLayout.CENTER); 
        
        	// OptionPanel Muterm
        
        rbLineal = new JRadioButton("Linear",true);
        rbSimpleMixed = new JRadioButton("Simple-Mixed");
        JPanel option = new JPanel(new GridLayout(2,1));
        option.add(rbLineal);
        option.add(rbSimpleMixed);
        ButtonGroup bgoptionMuterm = new ButtonGroup();
        bgoptionMuterm.add(rbLineal);
        bgoptionMuterm.add(rbSimpleMixed);
        JPanel optionMutermPanel=new JPanel(new FlowLayout());
        optionMutermPanel.add(option);
        
        // OptionPanel AProVE
        JPanel optionAProVEPanel = new JPanel(new GridLayout(2,1));
        
        JCheckBox conditionsForAProVE = new JCheckBox("AProVE handles conditions", false);
        conditionsForAProVE.setEnabled(false);
        
        JTFTimeout = new JTextField("30", 3);
        JTFTimeout.setHorizontalAlignment(JTextField.CENTER);
        JPanel JPTimeout = new JPanel(new FlowLayout(FlowLayout.LEFT));
        JPTimeout.add(new JLabel("Timeout: "));
        JPTimeout.add(JTFTimeout);
        JPTimeout.add(new JLabel(" seconds"));
        
        optionAProVEPanel.add(conditionsForAProVE);
        optionAProVEPanel.add(JPTimeout);
        
        terminationTool.add("CiME", optionCiMEPanel);
        terminationTool.addTab("MU-TERM", optionMutermPanel);
        terminationTool.addTab("AProVE", optionAProVEPanel);
        //Initialized the tab
        //terminationTool.setEnabledAt(1,false);
        //terminationTool.setEnabledAt(2,false);
        
        optionPanel.add(terminationTool, BorderLayout.CENTER);
        
        
        
        
        // Create the text areas

        JPanel inputMaude = new JPanel(new BorderLayout());
        JPanel labelMaude = new JPanel(new FlowLayout());
        JLabel inputMaudeLabel = new JLabel("InputText Maude");
        labelMaude.add(inputMaudeLabel);        
        maudeInputText = new JTextArea(30,33);
        JScrollPane maudeInputPanel = new JScrollPane(maudeInputText);
        inputMaude.add(labelMaude,BorderLayout.CENTER);
        inputMaude.add(maudeInputPanel,BorderLayout.SOUTH);
        maudeOutputText = new JTextArea(10, 20);
        JScrollPane maudeOutputPanel = new JScrollPane(maudeOutputText);
        
        mutermOutputText = new JTextArea(10, 20);        
        JScrollPane mutermOutputPanel = new JScrollPane(mutermOutputText);
        aproveOutputText = new JTextArea(10, 20);
        JScrollPane aproveOutputPanel = new JScrollPane(aproveOutputText);
        errorOutputText = new JTextArea(10, 20);
        JScrollPane errorOutputPanel = new JScrollPane(errorOutputText);

        // Create the JTabbedPane for the output text areas

        outTabbed = new JTabbedPane(JTabbedPane.TOP,
                                    JTabbedPane.SCROLL_TAB_LAYOUT);
           
                
        
        outTabbed.addTab("CiME output",cimeOutputPanel);
        outTabbed.addTab("MU-TERM output",mutermOutputPanel);
        outTabbed.addTab("Maude output", maudeOutputPanel);
        outTabbed.addTab("AProVE output", aproveOutputPanel);
        outTabbed.addTab("Error messages", errorOutputPanel);

        Container container = getContentPane();
        container.add(optionPanel, BorderLayout.WEST);
        container.add(inputMaude, BorderLayout.CENTER);
        container.add(outTabbed, BorderLayout.SOUTH);
        pack();
    }

    public void control(CtrlMTT ctrl) {
        // Check button
        //resetButton.addActionListener(crt);
        //resetButton.setActionCommand("reset");
        checkButton.addActionListener(ctrl);
        checkButton.setActionCommand("check termination");        

        // typing/condition desugaring transformation
        rbComplete.addActionListener(ctrl);
        rbComplete.setActionCommand("complete");
        rbSorts.addActionListener(ctrl);
        rbSorts.setActionCommand("no sorts");
        rbKinds.addActionListener(ctrl);
        rbKinds.setActionCommand("no kinds");

        // termination criterion
        rbStandard.addActionListener(ctrl);
        rbStandard.setActionCommand("standard");
        rbMinimal.addActionListener(ctrl);
        rbMinimal.setActionCommand("minimal");
        rbDependencyPair.addActionListener(ctrl);
        rbDependencyPair.setActionCommand("dp");

        // polynomial interpretation
        cbLinear.addActionListener(ctrl);
        cbLinear.setActionCommand("linear");
        cbSimple.addActionListener(ctrl);
        cbSimple.setActionCommand("simple");
        cbSimpleMixed.addActionListener(ctrl);
        cbSimpleMixed.setActionCommand("simple-mixed");

        // strategy transformation
        strategyTransfor.addActionListener(ctrl);
        strategyTransfor.setActionCommand("strategy");

        preferences.setActionCommand("preferences");
        preferences.addActionListener(ctrl);
        
        // strategy termination MuTerm
        rbLineal.addActionListener(ctrl);
        rbLineal.setActionCommand("linearMuTerm");
        rbSimpleMixed.addActionListener(ctrl);
        rbSimpleMixed.setActionCommand("simple-mixedMuTerm");
        
//        //Tool termination
//        rbCiME.addActionListener(ctrl);
//        rbCiME.setActionCommand("CiME");
//        rbMuTerm.addActionListener(ctrl);
//        rbMuTerm.setActionCommand("MuTerm");
//        rbAprove.addActionListener(ctrl);
//        rbAprove.setActionCommand("Aprove");
        
    }

    public void printMaudeText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                maudeInputText.setText(ss);
            }
        });
    }

    public String getMaudeInputText() {
        return maudeInputText.getText();
    }

    public void cleanMaudeText() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                maudeInputText.setText("");
            }
        });
    }

    public void printMaudeOutputText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                maudeOutputText.append(ss);
                outTabbed.setSelectedIndex(2);
            }
        });
    }

    public String getMaudeOutputText() {
        return maudeOutputText.getText();
    }

    public void cleanMaudeOutputText() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                maudeOutputText.setText("");
            }
        });
    }
    public void cleanMuTermOutputText() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                mutermOutputText.setText("");
            }
        });
    }
    public void cleanCiMEOutputText() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                cimeOutputText.setText("");
            }
        });
    }

    public void printCimeOutputText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                cimeOutputText.append(ss);
                outTabbed.setSelectedIndex(0);
            }
        });
    }
    
    public void cleanAproveOutputText() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                aproveOutputText.setText("");
            }
        });
    }

    public void printAproveOutputText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                aproveOutputText.append(ss);
                outTabbed.setSelectedIndex(3);
            }
        });
    }


    public void printMutermOutputText(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                mutermOutputText.append(ss);
                outTabbed.setSelectedIndex(1);
            }
        });
    }

    public int getMaxCoeffLinear() {
        return Integer.parseInt(tfMaxCoeffLinear.getText());
    }

    public int getMaxCoeffSimple() {
        return Integer.parseInt(tfMaxCoeffSimple.getText());
    }

    public int getMaxCoeffSimpleMixed() {
        return Integer.parseInt(tfMaxCoeffSimpleMixed.getText());
    }

    public void printErrorMessage(String msg) {
        final String ss = msg;
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                errorOutputText.setForeground(Color.RED);
                errorOutputText.append(ss + "\n");
                outTabbed.setSelectedIndex(4);
            }
        });
    }

    public boolean andOptimization() {
    	return andOptimization.isSelected();
    }
    
    public int timeoutAProVE() throws NumberFormatException {
    	return Integer.parseInt(JTFTimeout.getText());
    }
    
    public void run() {
        setVisible(true);
    }

    class OpenL implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JFileChooser c = new JFileChooser();
            try {
                int rVal = c.showOpenDialog(GUIMTT.this);
                if (rVal == JFileChooser.APPROVE_OPTION) {
                    BufferedReader file = new BufferedReader(
                            new FileReader(c.getCurrentDirectory().toString() +
                                           "/" +
                                           c.getSelectedFile().getName()));
                    String text = "", line = file.readLine();
                    while (line != null) {
                    	text += line + "\n";
                        line = file.readLine();
                    }
                    file.close();
                    printMaudeText(text);
                }
            } catch (IOException ex) {
                System.out.println("IO error reading file " +
                                   c.getCurrentDirectory().toString() + "/" +
                                   c.getSelectedFile().getName());
            }
        }
    }


    class SaveL implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JFileChooser c = new JFileChooser();
            try {
                int rVal = c.showSaveDialog(GUIMTT.this);
                if (rVal == JFileChooser.APPROVE_OPTION) {
                    String text = getMaudeInputText();
                    PrintWriter file = new PrintWriter(
                            new FileWriter(c.getCurrentDirectory().toString() +
                                           "/" +
                                           c.getSelectedFile().getName()));
                    file.print(text);
                    file.close();
                }
            } catch (IOException ex) {
                System.out.println("IO error writing file " +
                                   c.getCurrentDirectory().toString() + "/" +
                                   c.getSelectedFile().getName());
            }
        }
    }
}
