import java.io.IOException;
import java.net.UnknownHostException;

/** MaudeCiME sets up the basic arquitecture:
 *  - a server for CiME server requests,
 *  - a server for Maude server requests, and
 *  - a client
 *  communication takes place via sockets
 */
public class MTT {

    public static boolean DEBUG = false; //  if true, the debug info is printed
    public static boolean lanzaMTT = false;
    
    public static void main(String args[]) {
        if (args.length != 0 && args[0].equals("-debug")) {
            DEBUG = true;
        }
        //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        //UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        //UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");

        Configuration config = new Configuration();
		
        GUIMTT gui = new GUIMTT(config);
        try {
            javax.swing.SwingUtilities.invokeAndWait(gui);
        } catch (InterruptedException ie) {
            System.exit(-1);
        } catch (java.lang.reflect.InvocationTargetException ite) {
            System.exit(-1);
        }
        CtrlMTT client = new CtrlMTT(gui, config);
        gui.control(client);

        boolean ok = false;
        try {
            config.load();
            config.establishConnections(gui);
            ok = true;
        } catch (UnknownHostException uhe) {
            if (MTT.DEBUG) System.out.println("Unknown host: " + uhe.getMessage());
        } catch (IOException ioe) {
            if (MTT.DEBUG) { 
            	System.out.println("IO error: " + ioe.getMessage());
                ioe.printStackTrace();
            }
         }

        while (!ok) {
            ConfigMTTDialog cdialog = new ConfigMTTDialog(gui, config);
            lanzaMTT = true;
            cdialog.openDialog();
            if (cdialog.OK) {
                config.save();
                ok = false;
                try {                    
                	config.establishConnections(gui);
                    ok = true;
                } catch (UnknownHostException uhe) {
                    if (MTT.DEBUG) 
                    	System.out.println("Unknown host: " + uhe.getMessage());
                    gui.printErrorMessage(uhe.getMessage());
                } catch (IOException ioe) {
                	if (MTT.DEBUG) {
                		System.out.println("Entro por IOException"+ioe.getMessage());
                    	ioe.printStackTrace();
                	}
                	gui.printErrorMessage(ioe.getMessage());
                }
            } else {
                if (MTT.DEBUG) System.out.println("Nonvalid configuration");
                gui.printErrorMessage("Nonvalid configuration");
                System.exit(-1);
            }
        }
        lanzaMTT = false;
    }
}
