import java.io.InputStream;

/**
 * The class implements a thread that writes on the buffer intermediate the
 * characters that come from socket.
 */
class MaudeListener extends Listener {

	static final int MAX_WAIT = 5000; // in milli seconds

	protected StringBuffer buffer;

	MaudeListener(GUIMTT gui, InputStream in) {
		super(gui, in);
		this.buffer = new StringBuffer(1024);
	}

	public synchronized void printOutputText(String s) {
		buffer.append(s);
		notifyAll();
		gui.printMaudeOutputText(s);
	}

	public synchronized String getCommand() {
		String command = null;
		long startTime = System.currentTimeMillis();
		long now = startTime;
		while (buffer.indexOf("@@@/") == -1 && startTime + MAX_WAIT > now) {
			try {
				wait(startTime + MAX_WAIT - now);
			} catch (InterruptedException ie) {
				System.out.println("Error while sleeping");
				if (MTT.DEBUG)
					ie.printStackTrace();
			}
			now = System.currentTimeMillis();
		}
		if (buffer.indexOf("@@@/") != -1) {
			if (MTT.DEBUG)
				System.out.println("buffer (before): " + buffer);
			int beginIndex = buffer.indexOf("/@@@") + 4;
			int endIndex = buffer.indexOf("@@@/");
			command = buffer.substring(beginIndex, endIndex);
			if (MTT.DEBUG)
				System.out.println("command: " + command);
			buffer = buffer.replace(0, endIndex + 4, "");
			if (MTT.DEBUG)
				System.out.println("buffer (after): " + buffer);
		}
		return command;
	}
}
