#!/bin/bash

function die() {
	echo "!!! $1" < /dev/stderr
	exit 1
}

function test-one() {
  pn=${1/.rec/}
  echo $1
  echo ${pn}
  bn=$(basename ${pn})
  echo "testing" $bn $pn
  sglri -p syntax/REC.tbl -i $1 -o ${bn}.ast || die "Failed to parse"
  trans/recgen -i ${bn}.ast -o ${bn}.strast || die "Failed to translate"
  format-check --rtg $HOME/.nix-profile/share/stratego-front/Stratego.rtg -i ${bn}.strast || die "Failed to format check"
  pp-stratego -a -i ${bn}.strast -o ${bn}.str || die "Failed to pretty-print"
  strc -i ${bn}.str -la stratego-lib || die "Failed to compile"
}

for F in REC/*/*.rec; do
  echo $F 
  test-one $F
  if [ $? != 0 ]; then
    R=1
  fi
done

exit $R
