/* This grammar parses the simple rec language */
grammar Rec;
options {
  output=AST;
  ASTLabelType=RecTree;
}

tokens {
%include { rec/RecTokenList.txt }
}

@header {
  package parser;
  import parser.rec.RecTree;
}
@lexer::header {
  package parser;
  import parser.rec.RecTree;
}


program: 
  RECSPEC ID 
  SORTS (sort)*
  OPS (op)*
  (VARS (v+=var)*)?
  RULES (rule)*
  ENDSPEC
  (command)* 
  EOF
-> { v==null }? ^(Program ^(SpecRec ID ^(ConcSort (sort)*) ^(ConcOperator (op)*) ^(ConcVar )^(ConcRule (rule)*)) ^(ConcCommand (command)*))
->  ^(Program ^(SpecRec ID ^(ConcSort (sort)*) ^(ConcOperator (op)*) ^(ConcVar ($v)*)^(ConcRule (rule)*)) ^(ConcCommand (command)*))
;

sort:
  ID -> ^(Sort ID)
;

op:
  ID COLON (domain+=sort)* ARROW codomain=sort (LBRACE l=theories RBRACE)? 
    -> { l == null }?  ^(SimpleOperator ID ^(ConcSort ($domain)*) $codomain)
    -> ^(OperatorWithTheory ID ^(ConcSort ($domain)*) $codomain $l)
| INT COLON (domain+=sort)* ARROW codomain=sort (LBRACE l=theories RBRACE)? 
    -> { l == null }?  ^(SimpleOperator INT ^(ConcSort ($domain)*) $codomain)
    -> ^(OperatorWithTheory INT ^(ConcSort ($domain)*) $codomain $l)
| GET COLON (domain+=sort)* ARROW codomain=sort (LBRACE l=theories RBRACE)? 
    -> { l == null }?  ^(SimpleOperator GET ^(ConcSort ($domain)*) $codomain)
    -> ^(OperatorWithTheory GET ^(ConcSort ($domain)*) $codomain $l)
| CHECK COLON (domain+=sort)* ARROW codomain=sort (LBRACE l=theories RBRACE)? 
    -> { l == null }?  ^(SimpleOperator CHECK ^(ConcSort ($domain)*) $codomain)
    -> ^(OperatorWithTheory CHECK ^(ConcSort ($domain)*) $codomain $l)
| DOES COLON (domain+=sort)* ARROW codomain=sort (LBRACE l=theories RBRACE)? 
    -> { l == null }?  ^(SimpleOperator DOES ^(ConcSort ($domain)*) $codomain)
    -> ^(OperatorWithTheory DOES ^(ConcSort ($domain)*) $codomain $l)

;

theories: (theory)* -> ^(ConcTheory (theory)*);

theory:
    ASSOC -> ^(Associative)
  | COMM -> ^(Commutative)
  | NEUTR LPAR ID RPAR -> ^(Neutral ^(Cst ID))
  | STRAT LPAR (INT)* RPAR -> ^(Strat (INT)*)
;

var:
  (ID)* COLON sort -> ^(Vars ^(ConcName (ID)*) sort)
;

rule:
  lhs=term ARROW rhs=term (IF cond=condition (COMMA condition)*)?
    -> { cond == null }? ^(SimpleRule $lhs $rhs)
    -> ^(CondRule $lhs $rhs ^(ConcCond condition*))
;

command:
    GET ALL NORMAL FORMS FOR COLON term -> ^(GetAllNormalForms term)
  | GET NORMAL FORM FOR COLON term -> ^(GetNormalForm term)
  | DOES t1=term REWRITES TO t2=term '?' -> ^(CheckRewriteTo $t1 $t2)
  | CHECK THE CONFLUENCE OF COLON t1=term EQUALS t2=term -> ^(CheckConfluence $t1 $t2)
;

condition:
  t1=term 
  ( EQUALS t2=term -> ^(Equal $t1 $t2)
  | NOTEQUALS t2=term -> ^(NotEqual $t1 $t2)
  | DOUBLEARROW t2=term -> ^(RewriteTo $t1 $t2)
  )
;

term:
  ID (LPAR t1=term (COMMA term)* RPAR)? 
    -> { t1 == null }? ^(Cst ID)
    -> ^(App ID ^(ConcTerm term*))
| INT (LPAR t1=term (COMMA term)* RPAR)? 
    -> { t1 == null }? ^(Cst INT)
    -> ^(App INT ^(ConcTerm term*))
| GET (LPAR t1=term (COMMA term)* RPAR)? 
    -> { t1 == null }? ^(Cst GET)
    -> ^(App GET ^(ConcTerm term*))
| CHECK (LPAR t1=term (COMMA term)* RPAR)? 
    -> { t1 == null }? ^(Cst CHECK)
    -> ^(App CHECK ^(ConcTerm term*))
| DOES (LPAR t1=term (COMMA term)* RPAR)? 
    -> { t1 == null }? ^(Cst DOES)
    -> ^(App DOES ^(ConcTerm term*))
;

ASSOC : 'assoc';
COMM : 'comm';
NEUTR : 'id';
STRAT : 'strat';
ARROW : '->';
COLON : ':';
LPAR : '(';
RPAR : ')';
LBRACE : '{';
RBRACE : '}';
COMMA : ',';
DOUBLEARROW : '-->';
EQUALS : '-><-';
NOTEQUALS : '->/<-';
IF : 'if' ;
RECSPEC : 'REC-SPEC';
ENDSPEC : 'END-SPEC';
OPS : 'OPS';
VARS : 'VARS';
SORTS : 'SORTS';
RULES : 'RULES';
GET : 'get';
ALL : 'all';
NORMAL: 'normal';
FORM : 'form';
FORMS : 'forms';
FOR : 'for';
DOES : 'does';
REWRITES : 'rewrites';
TO : 'to';
CHECK : 'check';
THE : 'the';
CONFLUENCE : 'confluence';
OF : 'of';
ESC : '\\' ( 'n'| 'r'| 't'| 'b'| 'f'| '"'| '\''| '\\');
STRING : '"' (ESC|~('"'|'\\'|'\n'|'\r'))* '"';
INT : ('0'..'9')('0'..'9')*;
ID : ('a'..'z'|'A'..'Z'|'_'|'0'..'9'|'+'|'-'|'*'|'/'|'<'|'>'|'!'|'$'|'&'|'\''|'=')+;
WS : ( ' '
       | '\t'
       | ( '\r\n' // DOS
           | '\n'   // Unix
           | '\r'   // Macintosh
           )
       )
  {$channel=HIDDEN;}
  ;
SLCOMMENT :
  '//' (~('\n'|'\r'))* ('\n'|'\r'('\n')?)?
  {$channel=HIDDEN;}
  ;
MLCOMMENT :
  '/*' .* '*/' {$channel=HIDDEN;}
  ;
RECCOMMENT :
'%' (~('\n'|'\r'))* ('\n'|'\r'('\n')?)?
  {$channel=HIDDEN;}
;
