(****************************************************************************)
(***      Using the Distributed Genetic Algorithm Abstract Data Type      ***)
(***     v 1.0, by Enrique Alba Torres, 1/5/96 (last revised 5/11/96)     ***)
(****************************************************************************)
MODULE dfxx;
FROM ssGA IMPORT    GA, GENE_NUMBER, PHENOTYPE, SCHEMA, S_STATS, GENE_LENGTH,
                    Init_GA, Set_Up_GA, Steps_Up, Schema_Stats, Display, ITEM;
FROM dssGA IMPORT   dGA, Init_dGA, Set_Up_dGA, dSteps_Up,
                    Get_GA, Get_Best_GAid, MIG_TYPE, dSchema_Stats;
FROM IO   IMPORT    WrStr, WrCard, WrLngCard, WrReal, WrLn, WrChar, RdKey;
FROM MATHLIB IMPORT Cos, Pow;

VAR
  dga    : dGA;
  ga     : GA;
  steps  : CARDINAL;
  ch     : CHAR;
  i      : LONGCARD;
  sstats : S_STATS;

(*Massively Multimodal Deceptive Problem -from Goldberg's work on critical deme SIZE-*)
(*CAUTION!:Unitation values are appropriate only for 6-bit bipolar deception*)
PROCEDURE mmdp( ph : PHENOTYPE ) : REAL;
VAR
  i         : CARDINAL;
  unitation : CARDINAL;
  v         : REAL;
BEGIN
    v         := 0.0;
    FOR i:=1 TO GENE_NUMBER DO
        unitation := 0;
        WHILE (ph[i]>0.5) DO
              IF ((CARDINAL(ph[i]) MOD 2)=1) THEN INC(unitation); END;
              ph[i] := ph[i] / 2.0;
        END; (*WHILE*)
        CASE unitation OF           (*6-BIT BIPOLAR DECEPTION*)
             0 : v:=v+1.000000; |
             1 : v:=v+0.000000; |
             2 : v:=v+0.360384; |
             3 : v:=v+0.640576; |
             4 : v:=v+0.360384; |
             5 : v:=v+0.000000; |
             6 : v:=v+1.000000; |
        END; (*CASE*)
    END; (*FOR*)

    RETURN v;
END mmdp;

(*Generalized Rosenbrock Function*)
PROCEDURE Rosenbrock( ph : PHENOTYPE ) : REAL;
VAR
  i    : CARDINAL;
  value: REAL;
BEGIN
     value := 0.0;
     FOR i:=1 TO GENE_NUMBER DO
         value := value + 100.0*(ph[i+1]-ph[i]*ph[i])*(ph[i+1]-ph[i]*ph[i])+(ph[i]-1.0)*(ph[i]-1.0);
     END; (*FOR*)
     RETURN value;
END Rosenbrock;

(*Generalized Rastrigin function. Change the constants*)
PROCEDURE Rastrigin( ph : PHENOTYPE ) : REAL;

          (*Fit the decimal value to a range [a..b] with a given precision*)
          PROCEDURE Fit_In_Range( value, a, b, precision : REAL ) : REAL;
          BEGIN
              RETURN a+value*(b-a)/precision;
          END Fit_In_Range;
CONST

    PI2       = 2.0*3.14159;
    A         = 10.0;
    LEFT      = -5.12;
    RIGTH     =  5.12;
    MAXIMUM   = 896.0;

VAR
  i                     : CARDINAL;
  value, phi, precision : REAL;
BEGIN
    value := REAL(GENE_NUMBER)*A;

    precision := REAL(Pow(LONGREAL(2.0),LONGREAL(GENE_LENGTH)))-1.0;
    FOR i:=1 TO GENE_NUMBER DO
        phi:=Fit_In_Range(ph[i],LEFT,RIGTH,precision);
        value := value + phi*phi - A*REAL(Cos(LONGREAL(PI2*phi)));
    END; (*FOR*)

    RETURN MAXIMUM-value; (*Minimize! The optimum is Xi=0 with fitness 0.0*)

END Rastrigin;


PROCEDURE f( ph : PHENOTYPE ) : REAL;
VAR
  value : REAL;
BEGIN
    value := Rastrigin(ph);    (* <=== Write here your evaluation function !*)
    RETURN value;
END f;

BEGIN (*MODULE*)
      Init_dGA(dga);
      Set_Up_dGA(dga,(*unused*)3,1.0,0.01,best_ind,f);
      FOR steps:= 1 TO 125 DO
          i:=dSteps_Up(dga,LONGCARD(20));

          (*sstats := dSchema_Stats( dga, "1***************");
                                      (*Display(ga,statistics,1);*)

           * WrLngCard( sstats.actual_instances, 0 ); WrStr("   ");
           * WrLngCard( sstats.sch_th_instances, 0 ); WrLn;
           * WrReal(    sstats.actual_avg_f, 10, 10); WrLn;

           *)
          (*ch:=RdKey();*)

          WrStr("GA#"); WrCard(Get_Best_GAid(dga),0);WrLn;
          Get_GA(dga,Get_Best_GAid(dga),ga);
          Display(ga,individual,1);


      END;
      (****WrStr("FINAL STATISTICS"); WrLn;****)
END dfxx.