/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class WindowEventDemo
extends JApplet
implements WindowListener,
ActionListener {
    JTextArea display;
    JFrame window;
    JButton b1;
    JButton b2;
    static final String SHOW = "show";
    static final String CLEAR = "clear";
    String newline;

    public void init() {
        this.b1 = new JButton("Click to bring up a window.");
        this.b1.setActionCommand(SHOW);
        this.b1.addActionListener(this);
        this.b2 = new JButton("Click to clear the display.");
        this.b2.setActionCommand(CLEAR);
        this.b2.addActionListener(this);
        this.display = new JTextArea();
        this.display.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.display);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.b1, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.b2, "South");
        this.setContentPane(jPanel);
        this.window = new JFrame("Window Event Window");
        this.window.addWindowListener(this);
        this.window.getContentPane().add((Component)new JLabel("The applet listens to this window for window events."), "Center");
        this.window.pack();
        this.newline = System.getProperty("line.separator");
    }

    public void stop() {
        ((Component)this.window).setVisible(false);
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this.window).setVisible(false);
        this.displayMessage("Window closing", windowEvent);
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.displayMessage("Window closed", windowEvent);
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.displayMessage("Window opened", windowEvent);
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.displayMessage("Window iconified", windowEvent);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.displayMessage("Window deiconified", windowEvent);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.displayMessage("Window activated", windowEvent);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.displayMessage("Window deactivated", windowEvent);
    }

    void displayMessage(String string, WindowEvent windowEvent) {
        this.display.append(String.valueOf(string) + ": " + windowEvent.getWindow() + this.newline);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == SHOW) {
            this.window.pack();
            ((Component)this.window).setVisible(true);
            return;
        }
        this.display.setText("");
    }
}

