/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyDemo
extends Applet
implements KeyListener,
ActionListener {
    TextArea displayArea;
    TextField typingArea;

    public void init() {
        Button button = new Button("Clear");
        button.addActionListener(this);
        this.typingArea = new TextField(20);
        this.typingArea.addKeyListener(this);
        this.displayArea = new TextArea(5, 20);
        this.displayArea.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add("Center", this.displayArea);
        this.add("North", this.typingArea);
        this.add("South", button);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.displayInfo(keyEvent, "KEY TYPED: ");
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.displayInfo(keyEvent, "KEY PRESSED: ");
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.displayInfo(keyEvent, "KEY RELEASED: ");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.displayArea.setText("");
        ((TextComponent)this.typingArea).setText("");
        this.typingArea.requestFocus();
    }

    protected void displayInfo(KeyEvent keyEvent, String string) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        String string2 = Character.isISOControl(c) ? "key character = (an unprintable control character)" : "key character = '" + c + "'";
        String string3 = "key code = " + n + " (" + KeyEvent.getKeyText(n) + ")";
        String string4 = "modifiers = " + n2;
        String string5 = KeyEvent.getKeyModifiersText(n2);
        string4 = string5.length() > 0 ? String.valueOf(string4) + " (" + string5 + ")" : String.valueOf(string4) + " (no modifiers)";
        this.displayArea.append(String.valueOf(string) + "\n    " + string2 + "\n    " + string3 + "\n    " + string4 + "\n");
    }
}

