/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TextDemo
extends Applet
implements ActionListener {
    TextField textField;
    TextArea textArea;
    TextArea displayArea;

    public void init() {
        Button button = new Button("Clear");
        button.addActionListener(this);
        this.textField = new TextField(20);
        this.textField.addActionListener(new MyTextActionListener());
        this.textField.addTextListener(new MyTextListener("Text Field"));
        this.textArea = new TextArea(5, 20);
        this.textArea.addTextListener(new MyTextListener("Text Area"));
        this.displayArea = new TextArea(5, 20);
        this.displayArea.setEditable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.textField);
        panel.add("Center", this.textArea);
        gridBagConstraints.gridheight = 2;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.displayArea, gridBagConstraints);
        this.add(this.displayArea);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.add(button);
        this.textField.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.displayArea.setText("");
        this.textField.requestFocus();
    }

    class MyTextListener
    implements TextListener {
        String preface;

        public MyTextListener(String string) {
            TextDemo.this = TextDemo.this;
            this.preface = String.valueOf(string) + " text value changed.\n" + "   First 10 characters: \"";
        }

        public void textValueChanged(TextEvent textEvent) {
            TextComponent textComponent = (TextComponent)textEvent.getSource();
            String string = textComponent.getText();
            try {
                string = string.substring(0, 10);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            TextDemo.this.displayArea.append(String.valueOf(this.preface) + string + "\"\n");
            if (TextDemo.this.displayArea.isValid()) {
                TextDemo.this.displayArea.setCaretPosition(Integer.MAX_VALUE);
            }
        }
    }

    class MyTextActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TextDemo.this.textArea.getSelectionStart();
            int n2 = TextDemo.this.textArea.getSelectionEnd();
            TextDemo.this.textArea.replaceRange(TextDemo.this.textField.getText(), n, n2);
            TextDemo.this.textField.selectAll();
        }

        MyTextActionListener() {
            TextDemo.this = TextDemo.this;
        }
    }
}

