/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Vector;

public class ContainerDemo
extends Applet
implements ContainerListener,
ActionListener {
    TextArea display;
    Panel buttonPanel;
    Button addButton;
    Button removeButton;
    Button clearButton;
    Vector buttonList;

    public void init() {
        this.buttonList = new Vector(10, 10);
        this.addButton = new Button("Add a button");
        this.addButton.addActionListener(this);
        this.removeButton = new Button("Remove a button");
        this.removeButton.addActionListener(this);
        this.buttonPanel = new Panel();
        this.buttonPanel.addContainerListener(this);
        this.display = new TextArea(5, 20);
        this.display.setEditable(false);
        this.clearButton = new Button("Clear text area");
        this.clearButton.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.display, gridBagConstraints);
        this.add(this.display);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.clearButton, gridBagConstraints);
        this.add(this.clearButton);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.addButton, gridBagConstraints);
        this.add(this.addButton);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.removeButton, gridBagConstraints);
        this.add(this.removeButton);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.buttonPanel, gridBagConstraints);
        this.add(this.buttonPanel);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.displayMessage(" added to ", containerEvent);
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.displayMessage(" removed from ", containerEvent);
    }

    void displayMessage(String string, ContainerEvent containerEvent) {
        this.display.append(String.valueOf(((Button)containerEvent.getChild()).getLabel()) + " was" + string + containerEvent.getContainer().getClass().getName() + "\n");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            Button button = new Button("Button #" + (this.buttonList.size() + 1));
            this.buttonList.addElement(button);
            this.buttonPanel.add(button);
            this.buttonPanel.validate();
            return;
        }
        if (object == this.removeButton) {
            int n = this.buttonList.size() - 1;
            try {
                Button button = (Button)this.buttonList.elementAt(n);
                this.buttonPanel.remove(button);
                this.buttonList.removeElementAt(n);
                this.buttonPanel.validate();
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
        if (object == this.clearButton) {
            this.display.setText("");
        }
    }
}

