/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;

public class IconDemoApplet
extends JApplet
implements ActionListener {
    Vector pictures;
    JButton previous;
    JButton next;
    JLabel iconLabel;
    JLabel captionLabel;
    JLabel numberLabel;
    int current;
    int widthOfWidest;
    int heightOfTallest;
    boolean DEBUG = true;
    String imagedir;

    public IconDemoApplet() {
        this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
    }

    public void init() {
        this.imagedir = this.getParameter("IMAGEDIR");
        if (this.imagedir != null) {
            this.imagedir = String.valueOf(this.imagedir) + "/";
        }
        this.pictures = this.parseParameters();
        if (this.pictures.size() == 0) {
            this.captionLabel = new JLabel("No Images to View");
            this.captionLabel.setHorizontalAlignment(0);
            this.getContentPane().add(this.captionLabel);
            return;
        }
        Photo photo = (Photo)this.pictures.firstElement();
        ImageIcon imageIcon = new ImageIcon(this.getURL(String.valueOf(this.imagedir) + photo.filename));
        photo.setIcon(imageIcon);
        this.numberLabel = new JLabel("Picture " + (this.current + 1) + " of " + this.pictures.size());
        this.numberLabel.setHorizontalAlignment(2);
        this.numberLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        this.captionLabel = new JLabel(photo.caption);
        this.captionLabel.setHorizontalAlignment(0);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.iconLabel = new JLabel(imageIcon);
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setVerticalAlignment(0);
        this.iconLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.iconLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.iconLabel.getBorder()));
        this.iconLabel.setToolTipText(String.valueOf(photo.filename) + ": " + imageIcon.getIconWidth() + " X " + imageIcon.getIconHeight());
        Insets insets = this.iconLabel.getBorder().getBorderInsets(this.iconLabel);
        this.iconLabel.setPreferredSize(new Dimension(this.widthOfWidest + insets.left + insets.right, this.heightOfTallest + insets.bottom + insets.top));
        ImageIcon imageIcon2 = new ImageIcon(this.getURL(String.valueOf(this.imagedir) + "right.gif"));
        ImageIcon imageIcon3 = new ImageIcon(this.getURL(String.valueOf(this.imagedir) + "left.gif"));
        this.previous = new JButton("Previous Picture", imageIcon3);
        this.previous.setVerticalTextPosition(0);
        this.previous.setHorizontalTextPosition(4);
        this.previous.setMnemonic('p');
        this.previous.setActionCommand("previous");
        this.previous.addActionListener(this);
        this.previous.setEnabled(false);
        this.next = new JButton("Next Picture", imageIcon2);
        this.next.setVerticalTextPosition(0);
        this.next.setHorizontalTextPosition(2);
        this.next.setMnemonic('n');
        this.next.setActionCommand("next");
        this.next.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.numberLabel, gridBagConstraints);
        container.add(this.numberLabel);
        gridBagLayout.setConstraints(this.captionLabel, gridBagConstraints);
        container.add(this.captionLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.iconLabel, gridBagConstraints);
        container.add(this.iconLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.previous, gridBagConstraints);
        container.add(this.previous);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.next, gridBagConstraints);
        container.add(this.next);
    }

    protected Vector parseParameters() {
        String string;
        Vector<Photo> vector = new Vector<Photo>(10);
        int n = 0;
        String string2 = "IMAGE" + n;
        while ((string = this.getParameter(string2)) != null) {
            Photo photo = new Photo(string, this.getCaption(n), this.getWidth(n), this.getHeight(n));
            vector.addElement(photo);
            string2 = "IMAGE" + ++n;
        }
        return vector;
    }

    protected String getCaption(int n) {
        return this.getParameter("CAPTION" + n);
    }

    protected int getWidth(int n) {
        int n2 = 0;
        String string = this.getParameter("WIDTH" + n);
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if (n2 > this.widthOfWidest) {
            this.widthOfWidest = n2;
        }
        return n2;
    }

    protected int getHeight(int n) {
        int n2 = 0;
        String string = this.getParameter("HEIGHT" + n);
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if (n2 > this.heightOfTallest) {
            this.heightOfTallest = n2;
        }
        return n2;
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"IMAGEDIR", "string", "directory containing image files"}, {"IMAGEN", "string", "filename"}, {"CAPTIONN", "string", "caption"}, {"WIDTHN", "integer", "width of image"}, {"HEIGHTN", "integer", "height of image"}};
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Photo photo;
        ImageIcon imageIcon = null;
        this.iconLabel.setIcon(null);
        this.iconLabel.setText("... Loading ...");
        if (actionEvent.getActionCommand().equals("next")) {
            ++this.current;
            if (!this.previous.isEnabled()) {
                this.previous.setEnabled(true);
            }
            if (this.current == this.pictures.size() - 1) {
                this.next.setEnabled(false);
            }
        } else {
            --this.current;
            if (!this.next.isEnabled()) {
                this.next.setEnabled(true);
            }
            if (this.current == 0) {
                this.previous.setEnabled(false);
            }
        }
        if ((imageIcon = (photo = (Photo)this.pictures.elementAt(this.current)).getIcon()) == null) {
            imageIcon = new ImageIcon(this.getURL(String.valueOf(this.imagedir) + photo.filename));
            photo.setIcon(imageIcon);
        }
        this.iconLabel.setText("");
        this.iconLabel.setIcon(imageIcon);
        this.iconLabel.setToolTipText(String.valueOf(photo.filename) + ": " + imageIcon.getIconWidth() + " X " + imageIcon.getIconHeight());
        this.captionLabel.setText(photo.caption);
        this.numberLabel.setText("Picture " + (this.current + 1) + " of " + this.pictures.size());
    }

    protected URL getURL(String string) {
        URL uRL = this.getCodeBase();
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Couldn't create image: badly specified URL");
            return null;
        }
        return uRL2;
    }
}

