/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class RaceApplet1_1
extends Applet
implements Runnable {
    static final int NUMRUNNERS = 2;
    static final int SPACING = 20;
    Runner[] runners = new Runner[2];
    Thread updateThread;

    public void init() {
        String string = this.getParameter("type");
        int n = 0;
        while (n < 2) {
            this.runners[n] = new Runner();
            if (string.compareTo("unfair") == 0) {
                this.runners[n].setPriority(n + 2);
            } else {
                this.runners[n].setPriority(2);
            }
            ++n;
        }
        if (this.updateThread == null) {
            this.updateThread = new Thread((Runnable)this, "Thread Race");
            this.updateThread.setPriority(4);
        }
        this.addMouseListener(new MyAdapter());
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(Color.black);
        int n = 0;
        while (n < 2) {
            int n2 = this.runners[n].getPriority();
            graphics.drawString(new Integer(n2).toString(), 0, (n + 1) * 20);
            ++n;
        }
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n = 0;
        while (n < 2) {
            graphics.drawLine(20, (n + 1) * 20, 20 + this.runners[n].tick / 1000, (n + 1) * 20);
            ++n;
        }
    }

    public void run() {
        while (Thread.currentThread() == this.updateThread) {
            this.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        int n = 0;
        while (n < 2) {
            if (this.runners[n].isAlive()) {
                this.runners[n] = null;
            }
            ++n;
        }
        if (this.updateThread.isAlive()) {
            this.updateThread = null;
        }
    }

    class MyAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!RaceApplet1_1.this.updateThread.isAlive()) {
                RaceApplet1_1.this.updateThread.start();
            }
            int n = 0;
            while (n < 2) {
                if (!RaceApplet1_1.this.runners[n].isAlive()) {
                    RaceApplet1_1.this.runners[n].start();
                }
                ++n;
            }
        }

        MyAdapter() {
            RaceApplet1_1.this = RaceApplet1_1.this;
        }
    }
}

