/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class LineBreakSample
extends JApplet {
    private LineBreakMeasurer lineMeasurer;
    private int paragraphStart;
    private int paragraphEnd;
    private static final Hashtable map = new Hashtable();
    private static AttributedString vanGogh;

    static {
        map.put(TextAttribute.SIZE, new Float(18.0));
        vanGogh = new AttributedString("Many people believe that Vincent van Gogh painted his best works during the two-year period he spent in Provence. Here is where he painted The Starry Night--which some consider to be his greatest work of all. However, as his artistic brilliance reached new heights in Provence, his physical and mental health plummeted. ", map);
    }

    public void buildUI(Container container) {
        LineBreakPanel lineBreakPanel = new LineBreakPanel();
        container.add((Component)lineBreakPanel, "Center");
    }

    public void init() {
        this.buildUI(this.getContentPane());
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("HitTestSample");
        jFrame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        LineBreakSample lineBreakSample = new LineBreakSample();
        lineBreakSample.buildUI(jFrame.getContentPane());
        ((Component)jFrame).setSize(new Dimension(400, 250));
        ((Component)jFrame).setVisible(true);
    }

    class LineBreakPanel
    extends JPanel {
        public LineBreakPanel() {
            AttributedCharacterIterator attributedCharacterIterator = vanGogh.getIterator();
            LineBreakSample.this.paragraphStart = attributedCharacterIterator.getBeginIndex();
            LineBreakSample.this.paragraphEnd = attributedCharacterIterator.getEndIndex();
            LineBreakSample.this.lineMeasurer = new LineBreakMeasurer(attributedCharacterIterator, new FontRenderContext(null, false, false));
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.setBackground(Color.white);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            float f = dimension.width;
            float f2 = 0.0f;
            LineBreakSample.this.lineMeasurer.setPosition(LineBreakSample.this.paragraphStart);
            while (LineBreakSample.this.lineMeasurer.getPosition() < LineBreakSample.this.paragraphEnd) {
                TextLayout textLayout = LineBreakSample.this.lineMeasurer.nextLayout(f);
                float f3 = textLayout.isLeftToRight() ? 0.0f : f - textLayout.getAdvance();
                textLayout.draw(graphics2D, f3, f2 += textLayout.getAscent());
                f2 += textLayout.getDescent() + textLayout.getLeading();
            }
        }
    }
}

