/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class Philosopher
extends Thread {
    Chopstick leftStick;
    Chopstick rightStick;
    double x;
    double y;
    boolean sated;
    PhilosopherArea parent;
    int position;
    boolean stopRequested = false;

    Philosopher(PhilosopherArea philosopherArea, double d, double d2, int n) {
        super(philosopherArea.names[n]);
        this.parent = philosopherArea;
        this.position = n;
        this.x = d;
        this.y = d2;
        this.rightStick = this.parent.chopsticks[n];
        this.leftStick = n == 0 ? this.parent.chopsticks[4] : this.parent.chopsticks[n - 1];
        this.sated = false;
    }

    public void run() {
        while (!this.stopRequested) {
            try {
                int n = this.parent.controller.grabDelaySlider.getValue() * 100;
                Thread.sleep((int)(Math.random() * (double)n));
                this.rightStick.grab(this);
                this.parent.repaintPhil(this.position);
                n = this.parent.controller.grabDelaySlider.getValue() * 100;
                Thread.sleep((int)(Math.random() * (double)n));
                this.leftStick.grab(this);
                this.parent.repaintPhil(this.position);
                n = this.parent.controller.grabDelaySlider.getValue() * 100;
                Thread.sleep((int)(Math.random() * (double)n));
                this.eat();
                n = this.parent.controller.grabDelaySlider.getValue() * 100;
                Thread.sleep((int)(Math.random() * (double)n * 4.0));
                this.sated = false;
                this.parent.repaintPhil(this.position);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void eat() {
        this.rightStick.release(this);
        this.leftStick.release(this);
        this.sated = true;
        this.parent.repaintPhil(this.position);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect((int)this.x, (int)this.y, this.parent.imgs[0].getWidth(this.parent), this.parent.imgs[0].getHeight(this.parent) + 25);
        if (!this.sated) {
            if (this.rightStick.owner == this && this.leftStick.owner != this) {
                graphics.drawImage(this.parent.imgs[1], (int)this.x, (int)this.y, this.parent);
                return;
            }
            if (this.rightStick.owner == this && this.leftStick.owner == this) {
                graphics.drawImage(this.parent.imgs[2], (int)this.x, (int)this.y, this.parent);
                return;
            }
            graphics.drawImage(this.parent.imgs[0], (int)this.x, (int)this.y, this.parent);
            return;
        }
        graphics.drawImage(this.parent.imgs[0], (int)this.x, (int)this.y, this.parent);
        graphics.setColor(Color.black);
        graphics.drawString("Mmm!", (int)this.x + 8, (int)this.y + this.parent.imgs[0].getHeight(this.parent) + 13);
    }

    public void stopRequested() {
        this.stopRequested = true;
    }
}

