/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class PhilosopherArea
extends Canvas {
    PhilAnimator1_1 controller;
    static final double MARGIN = 10.0;
    static final int NUMPHILS = 5;
    Image[] imgs = new Image[3];
    double spacing;
    Philosopher[] philosophers = new Philosopher[5];
    Chopstick[] chopsticks = new Chopstick[5];
    boolean[] redraw = new boolean[5];
    String[] names = new String[]{"Arisduktle", "Dukrates", "Pythagorduke", "Duko", "Dukimedes"};
    boolean running = false;

    public PhilosopherArea(PhilAnimator1_1 philAnimator1_1) {
        this.controller = philAnimator1_1;
        MediaTracker mediaTracker = new MediaTracker(this);
        this.imgs[0] = philAnimator1_1.getImage(philAnimator1_1.getCodeBase(), "hungryduke.gif");
        mediaTracker.addImage(this.imgs[0], 0);
        this.imgs[1] = philAnimator1_1.getImage(philAnimator1_1.getCodeBase(), "rightspoonduke.gif");
        mediaTracker.addImage(this.imgs[1], 1);
        this.imgs[2] = philAnimator1_1.getImage(philAnimator1_1.getCodeBase(), "bothspoonsduke.gif");
        mediaTracker.addImage(this.imgs[2], 2);
        try {
            mediaTracker.waitForID(0);
            mediaTracker.waitForID(1);
            mediaTracker.waitForID(2);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Couldn't load one of the images");
        }
        this.spacing = (double)this.imgs[0].getWidth(this) + 10.0;
        this.createPhilosophersAndChopsticks();
        this.addMouseListener(new MyAdapter());
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        int n = 0;
        while (n < 5) {
            this.redraw[n] = true;
            ++n;
        }
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n = 0;
        while (n < 5) {
            if (this.redraw[n]) {
                this.philosophers[n].paint(graphics);
                this.redraw[n] = false;
            }
            ++n;
        }
    }

    public synchronized void repaintPhil(int n) {
        this.redraw[n] = true;
        this.repaint();
    }

    public void startPhilosophers() {
        int n = 0;
        while (n < 5) {
            this.philosophers[n].start();
            ++n;
        }
        this.running = true;
    }

    public void stopPhilosophers() {
        int n = 0;
        while (n < 5) {
            this.philosophers[n].stopRequested();
            ++n;
        }
    }

    public void createPhilosophersAndChopsticks() {
        double d = 80.0;
        double d2 = 85.0;
        int n = 0;
        while (n < 5) {
            this.chopsticks[n] = new Chopstick();
            ++n;
        }
        int n2 = 0;
        while (n2 < 5) {
            double d3 = (double)n2 * 1.2566370614359172;
            double d4 = Math.sin(d3) * d + d2;
            double d5 = Math.cos(d3) * d + d2;
            this.philosophers[n2] = new Philosopher(this, d4, d5, n2);
            this.repaintPhil(n2);
            ++n2;
        }
    }

    class MyAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (PhilosopherArea.this.running) {
                int n = 0;
                while (n < 5) {
                    PhilosopherArea.this.philosophers[n].suspend();
                    ++n;
                }
            } else {
                int n = 0;
                while (n < 5) {
                    PhilosopherArea.this.philosophers[n].resume();
                    ++n;
                }
            }
            PhilosopherArea.this.running = !PhilosopherArea.this.running;
        }

        MyAdapter() {
            PhilosopherArea.this = PhilosopherArea.this;
        }
    }
}

