/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SortItem1_1
extends Applet
implements Runnable {
    private Thread kicker;
    int[] arr;
    int h1 = -1;
    int h2 = -1;
    String algName;
    SortAlgorithm algorithm;

    void scramble() {
        int[] nArray = new int[this.getSize().height / 2];
        double d = (double)this.getSize().width / (double)nArray.length;
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = (int)((double)n * d);
        }
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int n3 = (int)((double)n2 * Math.random());
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
        }
        this.arr = nArray;
    }

    void pause() {
        this.pause(-1, -1);
    }

    void pause(int n) {
        this.pause(n, -1);
    }

    void pause(int n, int n2) {
        this.h1 = n;
        this.h2 = n2;
        if (this.kicker != null) {
            this.repaint();
        }
        try {
            Thread.sleep(20L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void init() {
        String string = this.getParameter("alg");
        if (string == null) {
            string = "BubbleSort";
        }
        this.algName = String.valueOf(string) + "Algorithm";
        this.scramble();
        this.setSize(100, 100);
        this.addMouseListener(new MyAdapter());
    }

    public void paint(Graphics graphics) {
        int[] nArray = this.arr;
        int n = this.getSize().height - 1;
        graphics.setColor(Color.lightGray);
        int n2 = nArray.length;
        while (--n2 >= 0) {
            graphics.drawLine(this.arr[n2], n, this.getSize().width, n);
            n -= 2;
        }
        graphics.setColor(Color.black);
        n = this.getSize().height - 1;
        int n3 = nArray.length;
        while (--n3 >= 0) {
            graphics.drawLine(0, n, this.arr[n3], n);
            n -= 2;
        }
        if (this.h1 >= 0) {
            graphics.setColor(Color.red);
            n = this.h1 * 2 + 1;
            graphics.drawLine(0, n, this.getSize().width, n);
        }
        if (this.h2 >= 0) {
            graphics.setColor(Color.blue);
            n = this.h2 * 2 + 1;
            graphics.drawLine(0, n, this.getSize().width, n);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void run() {
        try {
            if (this.algorithm == null) {
                this.algorithm = (SortAlgorithm)Class.forName(this.algName).newInstance();
                this.algorithm.setParent(this);
            }
            this.algorithm.init();
            this.algorithm.sort(this.arr);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void stop() {
        if (this.kicker != null) {
            try {
                this.kicker.stop();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
            this.kicker = null;
        }
        if (this.algorithm != null) {
            try {
                this.algorithm.stop();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
        }
    }

    private synchronized void startSort() {
        if (this.kicker == null || !this.kicker.isAlive()) {
            this.scramble();
            this.repaint();
            this.kicker = new Thread(this);
            this.kicker.start();
        }
    }

    final /* synthetic */ void access$0() {
        this.startSort();
    }

    class MyAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            SortItem1_1.this.access$0();
        }

        MyAdapter() {
            SortItem1_1.this = SortItem1_1.this;
        }
    }
}

