/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;

class BSMCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    Rectangle rect = new Rectangle(0, 0, 100, 50);
    BufferedImage bi;
    Graphics2D big;
    int last_x;
    int last_y;
    boolean firstTime = true;
    TexturePaint fillPolka;
    TexturePaint strokePolka;
    Rectangle area;
    boolean pressOut = false;

    public BSMCanvas() {
        this.setBackground(Color.white);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.bi = new BufferedImage(5, 5, 1);
        this.big = this.bi.createGraphics();
        this.big.setColor(Color.pink);
        this.big.fillRect(0, 0, 7, 7);
        this.big.setColor(Color.cyan);
        this.big.fillOval(0, 0, 3, 3);
        Rectangle rectangle = new Rectangle(0, 0, 5, 5);
        this.fillPolka = new TexturePaint(this.bi, rectangle);
        this.big.dispose();
        this.bi = new BufferedImage(5, 5, 1);
        this.big = this.bi.createGraphics();
        this.big.setColor(Color.cyan);
        this.big.fillRect(0, 0, 7, 7);
        this.big.setColor(Color.pink);
        this.big.fillOval(0, 0, 3, 3);
        rectangle = new Rectangle(0, 0, 5, 5);
        this.strokePolka = new TexturePaint(this.bi, rectangle);
        this.big.dispose();
    }

    boolean checkRect() {
        if (this.area == null) {
            return false;
        }
        if (this.area.contains(this.rect.x, this.rect.y, 100, 50)) {
            return true;
        }
        int n = this.rect.x;
        int n2 = this.rect.y;
        if (this.rect.x + 100 > this.area.width) {
            n = this.area.width - 99;
        }
        if (this.rect.x < 0) {
            n = -1;
        }
        if (this.rect.y + 50 > this.area.height) {
            n2 = this.area.height - 49;
        }
        if (this.rect.y < 0) {
            n2 = -1;
        }
        this.rect.setLocation(n, n2);
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.pressOut) {
            this.updateLocation(mouseEvent);
        } else {
            BufferedShapeMover.label.setText("First position the cursor on the rectangle and then drag.");
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.last_x = this.rect.x - mouseEvent.getX();
        this.last_y = this.rect.y - mouseEvent.getY();
        if (this.rect.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.updateLocation(mouseEvent);
        } else {
            BufferedShapeMover.label.setText("First position the cursor on the rectangle and then drag.");
            this.pressOut = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.rect.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.updateLocation(mouseEvent);
        } else {
            BufferedShapeMover.label.setText("First position the cursor on the rectangle and then drag.");
            this.pressOut = false;
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.firstTime) {
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            this.area = new Rectangle(dimension);
            this.bi = (BufferedImage)this.createImage(n, n2);
            this.big = this.bi.createGraphics();
            this.rect.setLocation(n / 2 - 50, n2 / 2 - 25);
            this.big.setStroke(new BasicStroke(8.0f));
            this.firstTime = false;
        }
        this.big.setColor(Color.white);
        this.big.clearRect(0, 0, this.area.width, this.area.height);
        this.big.setPaint(this.strokePolka);
        this.big.draw(this.rect);
        this.big.setPaint(this.fillPolka);
        this.big.fill(this.rect);
        graphics2D.drawImage((Image)this.bi, 0, 0, this);
    }

    public void updateLocation(MouseEvent mouseEvent) {
        this.rect.setLocation(this.last_x + mouseEvent.getX(), this.last_y + mouseEvent.getY());
        if (this.checkRect()) {
            BufferedShapeMover.label.setText("Rectangle located at " + this.rect.getX() + ", " + this.rect.getY());
        } else {
            BufferedShapeMover.label.setText("Please don't try to  drag outside the area.");
        }
        this.repaint();
    }
}

