import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.geom.*;
import java.awt.image.BufferedImage;

public class Poly extends JApplet{
    
    public void init(){
	buildUI(getContentPane());
    }
    public void buildUI(Container container) {
	setBackground(Color.white);
        PolyPanel polyPanel = new PolyPanel();
        container.add(polyPanel, BorderLayout.CENTER);
    }

    public static void main(String s[]) {

        JFrame f = new JFrame("Poly");
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });
        Poly applet = new Poly();      
        applet.buildUI(f.getContentPane());
        f.setSize(new Dimension(350,200));
        f.setVisible(true);
    }
}

class PolyPanel extends JPanel{

	int x, y, x1, y1, x2, y2;
	GeneralPath polygon;
	BufferedImage bi;
	Graphics2D big;
	boolean firstTime;
	Rectangle area;

	public PolyPanel(){
            polygon = new GeneralPath();
	    firstTime = true;
	    area = new Rectangle();
	}

        public GeneralPath createPath(int x, int y) {
	    x2 = x;
	    y2 = y;
            polygon.moveTo(x, y);
	    x -= 100;
	    polygon.lineTo(x, y);
	    y += 50;
	    polygon.lineTo(x, y);
	    x += 100;
	    polygon.lineTo(x, y);
            x += 10;
	    y -= 10;
	    x1 = x - 20;
	    y1 = y - 20;
	    polygon.curveTo(x, y, x1, y1, x2, y2);
	    return polygon;
	}

	public void paintComponent(Graphics g){
	   // super.paintComponent(g);
	    Graphics2D g2 = (Graphics2D)g;
	    if(firstTime){
  	      Dimension dim = getSize();
	      int w = dim.width;
              int h = dim.height;
	      x = w/2 + 50;
	      y = h/2 - 25;
	      polygon = createPath(x, y);
	      area = new Rectangle(w, h); 
              bi = (BufferedImage)createImage(w, h);
              big = bi.createGraphics();
 	      big.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
	      firstTime = false;
            }

            // Clears the shape that was previously drawn.
            big.setColor(Color.white);
  	    big.fillRect(0, 0, area.width, area.height);

	    big.setColor(Color.magenta);
	    big.setStroke(new BasicStroke(3.0f));
            big.draw(polygon);
            // Draws the buffered image to the screen.
            g2.drawImage(bi, 0, 0, this);
                 
	}
}
