package hall;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;

public class SearchEngines extends HttpServlet {


  public void doGet(HttpServletRequest request, HttpServletResponse response)
  throws ServletException, IOException {
    // The URLEncoder changes spaces to "+" signs and other
    // non-alphanumeric characters to "%XY", where XY is the
    // hex value of the ASCII (or ISO Latin-1) character.
    // The getParameter method decodes automatically, but since
    // we're just passing this on to another server, we need to
    // re-encode it.

    String searchString = URLEncoder.encode(request.getParameter("searchString"));
    String numResults = request.getParameter("numResults");
    String searchEngine = request.getParameter("searchEngine");
    SearchSpec[] commonSpecs = SearchSpec.getCommonSpecs();

    for(int i=0; i&lt;commonSpecs.length; i++) {
      SearchSpec searchSpec = commonSpecs[i];
      if (searchSpec.getName().equals(searchEngine)) {

        // encodeURL is just planning ahead in case this servlet
        // is ever used in an application that does session tracking.
        // If cookies are turned off, session tracking is usually
        // accomplished by URL rewriting, so all URLs returned
        // by servlets should be sent through encodeURL.

        String url = response.encodeURL(searchSpec.makeURL(searchString, numResults));
        response.sendRedirect(url);
        return;
      }
    }

    response.sendError(response.SC_NOT_FOUND, "No recognized search engine specified.");
  }

  public void doPost(HttpServletRequest request, HttpServletResponse response)
  throws ServletException, IOException {

    doGet(request, response);
  }

}
