package coreservlets;

import javax.servlet.*;
import javax.servlet.http.*;

public class ServletUtilities {
	// ... Other utilities shown earlier
	/** Read a parameter with the specified name, convert it
	* to an int, and return it. Return the designated default
	* value if the parameter doesnt exist or if it is an
	* illegal integer format.
	*/

	public static int getIntParameter(HttpServletRequest request, String paramName, int defaultValue) {
		String paramString = request.getParameter(paramName);
		int paramValue;
		try {
			paramValue = Integer.parseInt(paramString);
		} 
		catch(NumberFormatException nfe) { // null or bad format
			paramValue = defaultValue;
		}
	return(paramValue);
	}
// ...
}