package hall;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** Shows all the parameters sent to the servlet via either
 *  GET or POST. Specially marks parameters that have no values or
 *  multiple values.
 *  <P>
 *  Part of tutorial on servlets and JSP that appears at
 *  http://www.apl.jhu.edu/~hall/java/Servlet-Tutorial/
 *  1999 Marty Hall; may be freely used or adapted.
 */

public class ShowParameters extends HttpServlet {

  public void doGet(HttpServletRequest request, HttpServletResponse response)
  throws ServletException, IOException {

    response.setContentType("text/html");
    PrintWriter out = response.getWriter();
    String title = "Reading All Request Parameters";
    out.println(ServletUtilities.headWithTitle(title) +
                "&lt;BODY BGCOLOR=\"#FDF5E6\"&gt;\n" +
                "&lt;H1 ALIGN=CENTER&gt;" + title + "&lt;/H1&gt;\n" +
                "&lt;TABLE BORDER=1 ALIGN=CENTER&gt;\n" +
                "&lt;TR BGCOLOR=\"#FFAD00\"&gt;\n" +
                "&lt;TH&gt;Parameter Name&lt;TH&gt;Parameter Value(s)");
    Enumeration paramNames = request.getParameterNames();
    while(paramNames.hasMoreElements()) {
      String paramName = (String)paramNames.nextElement();
      out.println("&lt;TR&gt;&lt;TD&gt;" + paramName + "\n&lt;TD&gt;");
      String[] paramValues = request.getParameterValues(paramName);
      if (paramValues.length == 1) {
        String paramValue = paramValues[0];
        if (paramValue.length() == 0)
          out.print("&lt;I&gt;No Value&lt;/I&gt;");
        else
          out.print(paramValue);
      } else {
        out.println("&lt;UL&gt;");
        for(int i=0; i&lt;paramValues.length; i++) {
          out.println("&lt;LI&gt;" + paramValues[i]);
        }
        out.println("&lt;/UL&gt;");
      }
    }
    out.println("&lt;/TABLE&gt;\n&lt;/BODY&gt;&lt;/HTML&gt;");
  }

  public void doPost(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}