/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.applet.*;
import java.awt.*;
import java.util.Enumeration;

public class GetApplets extends Applet {
    private TextArea textArea;

    public void init() {
        setLayout(new BorderLayout());

        add("North", new Button("Click to call getApplets()"));

        textArea = new TextArea(5, 40);
        textArea.setEditable(false);
        add("Center", textArea);

        validate();
    }

    public boolean action(Event event, Object o) {
        printApplets();
        return false;
    }

    public String getAppletInfo() {
        return "GetApplets by Kathy Walrath";
    }

    public void printApplets() {
        //Enumeration will contain all applets on this page (including
        //this one) that we can send messages to.
        Enumeration e = getAppletContext().getApplets();

        textArea.appendText("Results of getApplets():\n");

        while (e.hasMoreElements()) {
            Applet applet = (Applet)e.nextElement();
            String info = ((Applet)applet).getAppletInfo();
            if (info != null) {
                textArea.appendText("- " + info + "\n");
            } else {
                textArea.appendText("- " + applet.getClass().getName() + "\n");
            } 
        }
        textArea.appendText("________________________\n\n");
    }
}

