/**
 * DemoBean -- This is implemented by the EnterPrise Bean author
 *
 *             This class must extend javax.ejb.SessionBean and implement
 *             the methods in this interface as well as providing the 
 *             implementation of the business methods.
 *
 *             Note: this is the first time you have had to write any code
 *                   so far everything else has had its implementation
 *                   generated for you.
 */
package ejb.demo;

import javax.ejb.*;
import java.io.Serializable;
import java.util.*;
import java.rmi.*;

public class DemoBean implements SessionBean {
  static final boolean verbose = true;

  private transient SessionContext ctx;
  private transient Properties     props;

  // Implement the methods in the SessionBean interface

  
  public void ejbActivate()  {
    if (verbose)
      System.out.println("ejbActivate called");
  }

  public void ejbRemove() {
    if (verbose)
      System.out.println("ejbRemove called");
  }

  public void ejbPassivate() {
    if (verbose)
      System.out.println("ejbPassivate called");
  }

  /**
   * Sets the session context.
   *
   * @param                   SessionContext
   */
  public void setSessionContext(SessionContext ctx) {
    if (verbose)
      System.out.println("setSessionContext called");
    this.ctx = ctx;
    props    = ctx.getEnvironment();
  }

 
  /**
   * This method corresponds to the create method in the home interface
   * "interfaces.DemoHome.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>DemoHome.create()</code>, the container allocates an instance of 
   * the EJBean and calls <code>ejbCreate()</code>.r
   */
  public void ejbCreate () {
    if (verbose)
      System.out.println("ejbCreate called");
  }

  /** 
   *   ******* HERE IS THE BUSINESS LOGIC *************
   *  Do the demoSelect() here ==> don't even go to the database in this eg.
   */
  public String demoSelect()
    throws RemoteException
  {
    
    return("hello world");
  }


  /**
   * Returns the JDBC pool name.
   *
   * @return                  string JDBC pool name
   */
  // public String getDatabaseName() {
  //  return (String)props.get("jdbcPoolName");
  //}


}
