/**
 * DemoClient -- demonstrates using a java application to talk to 
 *               a minimal minimal stateless session bean
 */

package ejb.demo;

import javax.ejb.*;
import javax.naming.*;
import java.rmi.*;
import java.util.Properties;

import examples.ejb.statelessSession.interfaces.*;

/**
 * DemoClient demostrates using a minimal stateless session bean
 *
 */

public class DemoClient {
  public static void main(String[] args) {
    System.out.println("\nBegin statelessSession DemoClient...\n");

    parseArgs(args);
     
    try {
      // Create A Demo object, in the server 
      // Note: the name of the class corresponds to the JNDI
      // property declared in the DeploymentDescriptor
      // From DeploymentDescriptor ...
      // beanHomeName              demo.DemoHome
      Context ctx          = getInitialContext();
      DemoHome dhome = (DemoHome) ctx.lookup("demo.DemoHome");

      System.out.println("Creating Demo\n");
      Demo demo = dhome.create();
      
      // Here is the call that executes the method on the 
      // server side object
      System.out.println("The result is " + demo.demoSelect());
     

    } 
    catch (Exception e) {
      System.out.println(":::::::::::::: Error :::::::::::::::::");
      e.printStackTrace();
    }
    System.out.println("\nEnd DemoClient...\n");
  }

  static void parseArgs(String args[]) {
    if ((args == null) || (args.length == 0)) 
      return;
    for (int i = 0; i < args.length; i++) {
      if (args[i].equals("-url")) 
        Integer.parseInt(args[++i]);
      else if (args[i].equals("-user")) 
        user = args[++i];
      else if (args[i].equals("-password")) 
        password = args[++i];
    }
  }
  
  static String user     = null;
  static String password = null;
  static String url      = "t3://localhost:7001";

  /**
   * Gets an initial context.
   *
   * @return                  Context
   * @exception               java.lang.Exception if there is
   *                          an error in getting a Context
   */
  static public Context getInitialContext() throws Exception {
    Properties p = new Properties();
    p.put(Context.INITIAL_CONTEXT_FACTORY,
          "weblogic.jndi.T3InitialContextFactory");
    p.put(Context.PROVIDER_URL, url);
    if (user != null) {
      System.out.println ("user: " + user);
      p.put(Context.SECURITY_PRINCIPAL, user);
      if (password == null) 
        password = "";
      p.put(Context.SECURITY_CREDENTIALS, password);
    } 
    return new InitialContext(p);
  }
}
