
/*
 * Copyright (c) 1995-1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import java.util.*;
import java.io.*;

public class Account {

   private double balance;
   private double creditLimit;

   public Account () {
      balance = 0;
      creditLimit = 500.00;
   }

   public void deposit(double amount) {
      balance += amount;
   }

   public void withdraw(double amount) throws OverLimitException {
      double value = balance - amount;
      if (value < creditLimit) {
        throw new OverLimitException(value);
      }
      else {
         balance = value;
      }
   }

    static public void main(String[] args) {

       Locale[] locales = {
          new Locale("en","US"),
          new Locale("de","DE")
       };

       Account credit = new Account();
       credit.deposit(20.00f);

       for (int k = 0; k < locales.length; k++) {
          try {
             credit.withdraw(1000.00f);
          }
          catch (OverLimitException e) {
             System.out.println("Locale: " + locales[k].toString());
             System.out.println(e.getLocalizedMessage(locales[k]));
          }
        } // for
   }
}
