
/*
 * Copyright (c) 1995-1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import java.util.*;
import java.text.*;
import java.io.*;

public class BuiltInException  {

   static public void defaultMessage() {

      try {
         FileInputStream in = new FileInputStream("vapor.txt");
      }
      catch (FileNotFoundException e) {
         System.out.println("e.getMessage = " + e.getMessage());
         System.out.println("e.getLocalizedMessage = " + e.getLocalizedMessage());
         System.out.println("e.toString = " + e.toString());
      }
   }

   static public void customMessage(Locale currentLocale) {

      System.out.println("Locale: " + currentLocale.toString());
      String fileName = "vapor.txt";

      try {
         FileInputStream in = new FileInputStream(fileName);
      }
      catch (FileNotFoundException e) {
         ResourceBundle messages =
             ResourceBundle.getBundle("ExceptionBundle",currentLocale);
         Object[] messageArguments = {fileName};
         MessageFormat formatter = new MessageFormat("");
         formatter.setLocale(currentLocale);
         formatter.applyPattern(messages.getString("template"));
         String errorOut = formatter.format(messageArguments);
         System.out.println(errorOut);
      }
   }

   static public void main(String[] args) {

      defaultMessage();
      System.out.println();

      customMessage(new Locale("en", "US"));
      customMessage(new Locale("de", "DE"));
   }
}
