import java.util.*;
import java.io.*;

class DBCacheRecord {
  Object data;
  long time;

  public DBCacheRecord(Object results, long when) {
    time=when;
    data=results;
  }
  public Object getResults() {
        return data;
  }
  public long getLastModified() {
        return time;
  }
}

public class DBCache {
  Map cache;

  public DBCache() {
    cache = new HashMap();
  }

  public Object getDBData(String dbcommand) {
    if(!cache.containsKey(dbcommand)) {
        synchronized(cache) {
          cache.put(dbcommand, readDBData(dbcommand));
        }
     } else {
       if((new Date().getTime() ) -
         ((DBCacheRecord)cache.get(
                dbcommand)).getLastModified()>=1000) {
         synchronized(cache) {
           cache.put(dbcommand, readDBData(dbcommand));
         }
       }
     }
     return ((DBCacheRecord)cache.get(dbcommand)).getResults();
  }

  public Object readDBData(String dbcommand) {

/*Insert your JDBC code here For Example:
  ResultSet results=stmt.executeQuery(dbcommand);
*/
    String results="example results";
    return(new DBCacheRecord(results,new Date().getTime()));

  }

  public static void main(String args[]) {
    DBCache d1=new DBCache();
    for(int i=1;i<=20;i++) {
        d1.getDBData(
          "select count(*) from results where completed <=sysDate");
    }
  }
}
