import java.awt.*;
import java.awt.event.*;
import java.awt.print.*;
import com.sun.java.swing.*; //Use this swing import
			       //line for release before Swing 1.1 and Java 2
//import javax.swing.*;  

class MyButton extends JButton implements Printable {

  public MyButton() {
   super("Print");

   }

   public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
     Graphics2D g2 = (Graphics2D) g;
     g2.translate(pf.getImageableX(), pf.getImageableY());
     Font  f = new Font("Monospaced",Font.PLAIN,12);
     g2.setFont (f);
     paint (g2);
     return Printable.PAGE_EXISTS;
   }
}

public class print2button extends JPanel implements ActionListener {

    private JButton b, b2;

    public print2button() {
	setBackground(Color.white);
        b = new MyButton();
	b2 = new MyButton();
	b2.setLabel("Print 2");
        b.addActionListener(this);
	b2.addActionListener(this);
        add(b);
	add(b2);

    }

    public void actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();

/* Set up Book */
	PageFormat landscape = printJob.defaultPage();
	PageFormat portrait = printJob.defaultPage();
	landscape.setOrientation(PageFormat.LANDSCAPE);
	landscape.setOrientation(PageFormat.PORTRAIT);
	Book bk = new Book();
	bk.append((Printable)b, landscape);
	bk.append((Printable)b2, portrait, 2);
        printJob.setPageable(bk);

//Page dialog
        PageFormat pf = printJob.pageDialog(printJob.defaultPage());

//Print dialog
        if(printJob.printDialog()){
          try { printJob.print(); } catch (Exception PrintException) { }
        }
/*
        try { printJob.print(); } catch (Exception PrintException) { }
*/
    }

    public static void main(String s[]) {
	WindowListener l = new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {System.exit(0);}
	};
	Frame f = new Frame("print2button");
	f.addWindowListener(l);
	f.add("Center", new print2button());
	f.pack();
	f.setSize(new Dimension(400,300));
	f.show();
    }
}
