package auction;

import javax.swing.table.AbstractTableModel;
import javax.swing.event.TableModelEvent;
import java.text.NumberFormat; 
import java.util.*;
import java.awt.*;
import javax.swing.*;

public class ResultsModel extends AbstractTableModel {

    String[]  columnNames={};
    Vector rows = new Vector();


    public String getColumnName(int column) {
        if (columnNames[column] != null) {
            return columnNames[column];
        } else {
            return "";
        }
    }

    public boolean isCellEditable(int row, int column) {
        if(column == 4) {
           return true;
        } else {
           return false;
        }
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return rows.size();
    }

    public Object getValueAt(int row, int column) {
        Vector tmprow = (Vector)rows.elementAt(row);
        return tmprow.elementAt(column);          
    }

    public  void update(Enumeration enum) {
        try {
        columnNames = new String[5];     
        columnNames[0]=new String("Auction Id #");
        columnNames[1]=new String("Description");
        columnNames[2]=new String("High Bid");
        columnNames[3]=new String("# of bids");
        columnNames[4]=new String("End Date");
        while((enum !=null) && (enum.hasMoreElements())) {

            while(enum.hasMoreElements()) {
                AuctionItem auctionItem=(AuctionItem)enum.nextElement();
                Vector items=new Vector(); 
                items.addElement(new Integer(auctionItem.getId()));       
                items.addElement(auctionItem.getSummary()); 
                int bidcount= auctionItem.getBidCount();                 
                if(bidcount >0) {
                   items.addElement(NumberFormat.getCurrencyInstance().format(auctionItem.getHighBid()));
                } else {
                   items.addElement("-");
                }
                items.addElement(new Integer(bidcount));                 
                items.addElement(new JButton(auctionItem.getEndDate().toString()));
                rows.addElement(items);
            }
        }                       

        fireTableStructureChanged();
        } catch (Exception e) {
           System.out.println("Exception e"+e);
        }
    }

}
