package auction;

import java.rmi.RemoteException;
import javax.ejb.*;
import java.util.*;
import java.text.NumberFormat;

public class AuctionItemBean implements EntityBean {

    public String summary;
    public String seller;
    public int id;
    public String description;
    public double startprice=0;
    public java.sql.Date startdate;
    public java.sql.Date enddate;
    public double maxbid,increment;
    public int bidcount;
    public String highbidder;
    protected EntityContext ctx;
    public static int counter=400000;

    public String getDescription() throws RemoteException { 
        return description; 
    }

    public String getSummary() throws RemoteException { 
        return summary; 
    }

    public int getId() throws RemoteException { 
        return id; 
    }

    public String getSeller() throws RemoteException { 
        return seller; 
    }

    public double getIncrement() throws RemoteException {
        return increment;
    }

    public double getHighBid() throws RemoteException {
        return maxbid;
    }

    public int getBidCount() throws RemoteException {
        return bidcount;
    }

    public String getHighBidder() throws RemoteException {
	return highbidder;
    }

    public Date getStartDate() throws RemoteException {
        return startdate;
    }

    public Date getEndDate() throws RemoteException {
        return enddate;
    }

    public double getStartPrice() throws RemoteException {
        return startprice;
    }

    public boolean isAuctionStillRunning() {
        Date now = (Calendar.getInstance()).getTime();

        if(enddate.getTime()>=now.getTime()) {
		return true;
	}
	else {
		return false;
	}
    }

    public int setHighBid(String buyer, double amount, double increment) 
		                                     throws RemoteException{
	if( isAuctionStillRunning()) {
            highbidder=buyer;
            maxbid=amount; 
            this.increment=increment;
            bidcount++;
            return(0);
	}
	else {
	    return (-1);
	}
    }

    public void ejbCreate(String theseller, String thedescription, 
                       int duration, double thestartprice, String thesummary) 
                              throws CreateException, RemoteException {
        double inc=0;

        try{
            inc=Math.round((thestartprice*100)/1000);
        } catch(Exception e) {
            System.out.println("error parsing money"+e);
        }
        ejbCreate(counter++, theseller, thedescription, duration, 
                      thestartprice, thesummary, inc);
    }

    public void ejbCreate(int theid, String theseller, String thedescription, 
                        int duration, double thestartprice, 
                               String thesummary, double theincrement) 
                                  throws CreateException, RemoteException {
        id=theid;
        seller=theseller;
        description=thedescription;
        Calendar currenttime=Calendar.getInstance();
        Date currentdate=currenttime.getTime();
        startdate=new java.sql.Date(currentdate.getTime());
        currenttime.add(Calendar.DATE,duration);
        enddate=new java.sql.Date((currenttime.getTime()).getTime());
        startprice=thestartprice;
        summary=thesummary;
        maxbid=startprice;
        increment=theincrement;
    }


    public void ejbPostCreate(int id, String theseller, String thedescription, 
                          int duration, double thestartprice, 
                               String thesummary, double increment) 
                                   throws CreateException, RemoteException {
    }

    public void ejbPostCreate(String theseller, String thedescription, 
                         int duration, double thestartprice, String thesummary) 
                                   throws CreateException, RemoteException {
    }

    public void setEntityContext(javax.ejb.EntityContext ctx) 
                                          throws RemoteException {
        this.ctx = ctx;
    }

    public void unsetEntityContext() throws RemoteException {   
        ctx = null;  
    } 

    public void ejbRemove() throws RemoteException, RemoveException { }
    public void ejbActivate() throws RemoteException { }
    public void ejbPassivate() throws RemoteException { }
    public void ejbLoad() throws RemoteException { }
    public void ejbStore() throws RemoteException { }
}

