package bidder;

import java.rmi.RemoteException;
import javax.ejb.*;
import java.util.*;
import java.text.NumberFormat;
import java.io.Serializable;
import javax.naming.*;
import auction.*;
import registration.*;

public class BidderBean implements SessionBean {

    protected SessionContext sctx;
    Properties p = new Properties();
    Context ctx;

    public int placeBid(int item, String buyer, String password, double amount) throws RemoteException { 

        double highbid, increment=0;
        int bidcount;
        try{

	RegistrationHome rhome = (RegistrationHome) ctx.lookup("registration");
	RegistrationPK rpk=new RegistrationPK();
	rpk.theuser=buyer;
	Registration newbidder=rhome.findByPrimaryKey(rpk);
	if((newbidder == null)|| (!newbidder.verifyPassword(password))) {
            return(Auction.INVALID_USER);	
	}

        AuctionItemHome home = (AuctionItemHome) ctx.lookup("auctionitems");
        AuctionItemPK pk=new AuctionItemPK();
        pk.id=item;
	
        AuctionItem ai=home.findByPrimaryKey(pk);
	if(ai !=null) {
            increment=ai.getIncrement();      
	    highbid=ai.getHighBid();
	    bidcount=ai.getBidCount();
	    if((amount >=(highbid+increment)) || (bidcount == 0 && amount >=highbid)) {
                if(ai.setHighBid(buyer,amount, (amount*100)/1000)>=0) {
                   return Auction.HIGH_BID;
		}
		else {
		   return Auction.AUCTION_OVER;
		}
            }
            else {
		return Auction.OUT_BID;
            }
	}
	else {
		return Auction.INVALID_ITEM;
	}
        }catch(Exception e){ 
           System.out.println("placeBid: "+e);
           return Auction.INVALID_ITEM;
        }
    }

    public Enumeration getItemList() throws RemoteException { 

        Enumeration enum=null;
        try{
            AuctionItemHome home = (AuctionItemHome) ctx.lookup("auctionitems");
            enum=(Enumeration)home.findAllItems();
        } catch (Exception e) {
	    System.out.println("getItemList: "+e);
	    return null;
        }
        return enum;    
    }

    public Enumeration getNewItemList() throws RemoteException { 

        Enumeration enum=null;
        try{
            AuctionItemHome home = (AuctionItemHome) ctx.lookup("auctionitems");
            Calendar currenttime=Calendar.getInstance();
            enum=(Enumeration)home.findAllNewItems(new java.sql.Date((currenttime.getTime()).getTime()));
        } catch (Exception e) {
	    System.out.println("getNewItemList: "+e);
	    return null;
        } 
        return enum;    
    }

    public Enumeration getClosedItemList() throws RemoteException {

        Enumeration enum=null;
        try{
            AuctionItemHome home = (AuctionItemHome) ctx.lookup("auctionitems");
            Calendar currenttime=Calendar.getInstance();
            enum=(Enumeration)home.findAllClosedItems(new java.sql.Date((currenttime.getTime()).getTime()));
        }catch (Exception e) {
	    System.out.println("getClosedItemList: "+e);
	    return null;
        }
        return enum;
    }

    public Enumeration getMatchingItemsList(String searchString) throws RemoteException {

        Enumeration enum=null;
        try{
            AuctionItemHome home = (AuctionItemHome) ctx.lookup("auctionitems");
            enum=(Enumeration)home.findAllMatchingItems(searchString);
        }catch (Exception e) {
	    System.out.println("getMatchingItemList: "+e);
	    return null;
        }
        return enum;
    }


    public void ejbCreate() throws CreateException, RemoteException {
        Properties p = new Properties();
        p.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.TengahInitialContextFactory");
        try{
	    ctx = new InitialContext(p);
        }catch(Exception e) {
	    System.out.println("create exception: "+e);
	}
    }

    public void setSessionContext(SessionContext sctx) throws RemoteException {
        this.sctx = sctx;
    }

    public void unsetSessionContext() throws RemoteException {   
        sctx = null;  
    } 

    public void ejbRemove() {}
    public void ejbActivate() throws RemoteException { }
    public void ejbPassivate() throws RemoteException { }
}


