package registration;

import java.sql.*;

import org.omg.CosNaming.*;
import org.omg.CORBA.*;


public class RegistrationServer extends _RegistrationHomeImplBase{

    static {
        new pool.JDCConnectionDriver("postgresql.Driver", 
		"jdbc:postgresql:ejbdemo","postgres", "pass");
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:jdc:jdcpool");
    }

    public registration.RegistrationPK create(String theuser, 
		String password, String emailaddress, String creditcard) 
		throws registration.CreateException{
        
        double balance=0;
        Connection con = null;
        PreparedStatement ps = null;;

        try {
           con=getConnection();
           ps=con.prepareStatement("insert into registration(
		theuser, password, emailaddress, 
		creditcard, balance) values (?, ?, ?, ?, ?)");
           ps.setString(1, theuser);
           ps.setString(2, password);
           ps.setString(3, emailaddress);
           ps.setString(4, creditcard);
           ps.setDouble(5, balance);
           
           if (ps.executeUpdate() != 1) {
	//JDBC did not create a row
               throw new CreateException ();
           }
           RegistrationPK primaryKey = new RegistrationPKImpl();
           primaryKey.theuser(theuser);
           return primaryKey;
       } catch (CreateException ce) {
          throw ce;
       } catch (SQLException sqe) {
          throw new CreateException ();
       } finally {
          try {
             ps.close();
            con.close();
          } catch (Exception ignore) {
          }
       }
    }

    public registration.Registration findByPrimaryKey(
		registration.RegistrationPK pk) 
		throws registration.FinderException {
        if ((pk == null) || (pk.getUser() == null)) {
	//Primary key cannot be null
            throw new FinderException ();
        }
        return(refresh(pk));
    }

    private Registration refresh(RegistrationPK pk)
                      throws FinderException {

        if (pk == null) {
	//Primary key cannot be null
            throw new FinderException ();
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
           con=getConnection();
           ps=con.prepareStatement("select password, emailaddress, 
		creditcard, balance from registration where theuser = ?");
           ps.setString(1, pk.getUser());
           ps.executeQuery();
           ResultSet rs = ps.getResultSet();
           if (rs.next()) {
              RegistrationImpl reg= new RegistrationImpl();
              reg.theuser = pk.getUser();
              reg.password = rs.getString(1);
              reg.emailaddress = rs.getString(2);
              reg.creditcard = rs.getString(3);
              reg.balance = rs.getDouble(4);
              return reg;
           }
           else {
               throw new FinderException ();
           }
       }
       catch (SQLException sqe) {
           throw new FinderException();
       }
       finally {
          try {
             ps.close();
             con.close();
          }
          catch (Exception ignore) {}
       }
      return null;
    }

   
    public static void main(String args[]) {
        String[] orbargs = { "-ORBInitialPort 1050"};
        ORB orb = ORB.init(orbargs, null) ;

        RegistrationServer rs= new RegistrationServer();
        try {
            org.omg.CORBA.Object nameServiceObj = 
                   orb.resolve_initial_references("NameService") ;
            NamingContext nctx= NamingContextHelper.narrow(nameServiceObj);
            NameComponent[] fullname = new NameComponent[2];
            fullname[0] = new NameComponent("auction", "");
            fullname[1] = new NameComponent("RegistrationBean", "");

            NameComponent[] tempComponent = new NameComponent[1];
            for(int i=0; i < fullname.length-1; i++ ) {
                tempComponent[0]= fullname[i];
                try {
                   nctx=nctx.bind_new_context(tempComponent);
                }catch (Exception e){}
            }
            tempComponent[0]=fullname[fullname.length-1];
            nctx.bind(tempComponent, rs);
            java.lang.Object sync= new java.lang.Object();
            synchronized(sync) {
               sync.wait();
            }
	} catch (Exception e) {
            System.out.println("Exception occured="+e);
        }
   }
}

class RegistrationImpl extends _RegistrationImplBase {
    public String theuser, password, creditcard, emailaddress;
    public double balance;

    public boolean verifyPassword(String password) {
        if (this.password.equals(password)) {
            return true;
        } else {
            return false;
        }
    }

    public String getEmailAddress() {
        return emailaddress;
    }

    public String getUser() {
        return theuser;
    }

    public int adjustAccount(double amount) {
        balance=balance+amount;
        return(0);
    }

    public double getBalance() {
        return balance;
    }
}
