package seller;

import java.rmi.RemoteException;
import javax.ejb.*;
import java.util.*;
import java.text.NumberFormat;
import java.io.Serializable;
import javax.naming.*;
import auction.*;
import registration.*;
import org.omg.CosNaming.*;
import org.omg.CORBA.*;


public class SellerBean implements SessionBean {

    protected SessionContext ctx;
    javax.naming.Context ectx;
    Hashtable env = new Hashtable();
    ORB orb = null;
    NamingContext nctx= null;

    public int insertItem(String seller, String password, String description, int auctiondays, double startprice, String summary) throws RemoteException { 

        try{
        NameComponent[] fullname = new NameComponent[2];
        fullname[0] = new NameComponent("auction", "");
        fullname[1] = new NameComponent("RegistrationBean", "");

        RegistrationHome regRef = RegistrationHomeHelper.narrow(nctx.resolve(fullname));
        RegistrationPKImpl rpk= new RegistrationPKImpl();
        rpk.theuser(seller);
        Registration newseller = RegistrationHelper.narrow(regRef.findByPrimaryKey(rpk));
	if((newseller == null)|| (!newseller.verifyPassword(password))) {
            return(Auction.INVALID_USER);	
	}

        AuctionItemHome home = (AuctionItemHome) ectx.lookup("auctionitems");
        AuctionItem ai= home.create(seller, description, auctiondays, startprice, summary);
	if(ai == null) {
           return Auction.INVALID_ITEM;
	} 
	else {
           return(ai.getId()); 
	}

        }catch(Exception e){ 
           System.out.println("insert problem="+e);
           return Auction.INVALID_ITEM;
        }
    }

    public void ejbCreate() throws javax.ejb.CreateException, RemoteException {
        env.put(javax.naming.Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.TengahInitialContextFactory");
        try {
            ectx = new InitialContext(env);
        } catch (NamingException e) {
            System.out.println("problem contacting EJB server");
            throw new javax.ejb.CreateException();
        }
        try {
           String[] args = { "-ORBInitialPort 1050"};
           orb = ORB.init(args, null) ;

           org.omg.CORBA.Object nameServiceObj = orb.resolve_initial_references("NameService") ;
           nctx= NamingContextHelper.narrow(nameServiceObj);
        } catch(org.omg.CORBA.SystemException e) {
            throw new javax.ejb.CreateException("CORBA Error in SellerCreate "+e);
        } catch ( org.omg.CORBA.ORBPackage.InvalidName e) {
            throw new javax.ejb.CreateException("CORBA NameError in SellerCreate "+e);
        }
    }

    public void setSessionContext(SessionContext ctx) throws RemoteException {
        this.ctx = ctx;
    }

    public void unsetSessionContext() throws RemoteException {   
        ctx = null;  
    } 

    public void ejbRemove() {}
    public void ejbActivate() throws RemoteException {
	System.out.println("activating seller bean");
    }
    public void ejbPassivate() throws RemoteException { 
	System.out.println("passivating seller bean");
    }
}


