package registration;

import java.rmi.RemoteException;
import javax.ejb.*;
import java.util.*;
import java.text.NumberFormat;
import java.io.*;

// Bean-managed persistance using serialization 

public class RegistrationBean implements EntityBean, Serializable{

    private transient EntityContext ctx;
    public String theuser, password, creditcard, emailaddress;
    public double balance;


    public boolean verifyPassword(String password) throws RemoteException { 
	if (this.password.equals(password)) {
	    return true;
	} else {
            return false;
        }
    }
    public String getEmailAddress() throws RemoteException { 
	return emailaddress;
    }
    public String getUser() throws RemoteException { 
	return theuser;
    }
    public int adjustAccount(double amount) throws RemoteException { 
        balance=balance+amount;
        return(0);
    }

    public double getBalance() throws RemoteException {
	return balance;
    }

    public RegistrationPK ejbCreate(String theuser, String password, String emailaddress, String creditcard) throws CreateException, RemoteException {

	this.theuser=theuser;
	this.password=password;
	this.emailaddress=emailaddress;
	this.creditcard=creditcard;
	this.balance=0;

        try {
	   String fname=new String("pdata"+File.separator+theuser); 
	   if(!(new File(fname)).exists()) {
                try {
                    FileOutputStream fstream= new FileOutputStream(fname);
                    ObjectOutput out = new ObjectOutputStream(fstream);
                    out.writeObject(this);
                    out.flush();
                    out.close();
	        } catch (Exception e) {
                   throw new CreateException ("Error creating new user "+e);
	        }
	   } else {
               throw new CreateException ("User already exists");
	   }
           RegistrationPK primaryKey = new RegistrationPK();
           primaryKey.theuser = theuser;
           return primaryKey;
       } catch (CreateException ce) {
          throw ce;
       }
    }
 

    public void ejbPostCreate(String theuser, String password, String emailaddress, String creditcard) throws CreateException, RemoteException {
    }

    public void setEntityContext(javax.ejb.EntityContext ctx) throws RemoteException {
    this.ctx = ctx;
    }

    public void unsetEntityContext() throws RemoteException {   
    ctx = null;  
    } 

    public void ejbRemove() throws RemoteException, RemoveException { }
    public void ejbActivate() throws RemoteException { }
    public void ejbPassivate() throws RemoteException { }
    public void ejbLoad() throws RemoteException { 
       try {
          refresh((RegistrationPK) ctx.getPrimaryKey());
       }
       catch (FinderException fe) {
          throw new RemoteException (fe.getMessage());
       }
    }

    public void ejbStore() throws RemoteException { 

        String fname=new String("pdata"+File.separator+theuser);
        try {
            FileOutputStream fstream= new FileOutputStream(fname);
            ObjectOutput out = new ObjectOutputStream(fstream);
            out.writeObject(this);
            out.flush();
            out.close();
	} catch (Exception e) {
		throw new RemoteException("cannot store value"+e);
	}
    }

    public RegistrationPK ejbFindByPrimaryKey(RegistrationPK pk)
                           throws FinderException, RemoteException {

        if ((pk == null) || (pk.theuser == null)) {
            throw new FinderException ("primary key cannot be null");
        }
        refresh(pk);
        return pk;
    }

    private void refresh(RegistrationPK pk) 
                      throws FinderException, RemoteException {

        RegistrationBean rb=null;

        if (pk == null) {
            throw new RemoteException ("primary key cannot be null");
        }
	String fname=new String("pdata"+File.separator+pk.theuser); 
	if ((new File(fname)).exists()) {
            try {
                FileInputStream fstream = new FileInputStream(fname);
                ObjectInputStream in = new ObjectInputStream(fstream);
                rb=(RegistrationBean)in.readObject();
                in.close();
            } catch (Exception e ) {
	       throw new FinderException("no value found "+e);
	    }
        } else {
	    throw new FinderException("no value found "+pk.theuser);
	}
        theuser = rb.theuser;
        password = rb.password;
        emailaddress = rb.emailaddress;
        creditcard = rb.creditcard;
        balance = rb.balance;
    }

}

