package seller;

import java.rmi.RemoteException;
import java.rmi.*;
import javax.ejb.*;
import java.util.*;
import java.text.NumberFormat;
import java.io.Serializable;
import javax.naming.*;
import auction.*;
import registration.*;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;

public class SellerBean implements SessionBean, ReturnResults {

    protected SessionContext ctx
    javax.naming.Context ectx;
    Hashtable env = new Hashtable();
    AuctionServlet callee=null;
    Boolean ready=new Boolean("false");
    ArrayList returned;

    public int insertItem(String seller, String password, 
		String description, int auctiondays, 
		double startprice, String summary) 
		throws RemoteException { 

        try{

        RegistrationHome regRef = (RegistrationHome)
			Naming.lookup("//localhost/registration2");
        RegistrationPK rpk= new RegistrationPK();
        rpk.setUser(seller);
        Registration newseller = (Registration)regRef.findByPrimaryKey(rpk);
	if((newseller == null)|| (!newseller.verifyPassword(password))) {
            return(Auction.INVALID_USER);
	}

        AuctionItemHome home = (AuctionItemHome) 
		ectx.lookup("auctionitems");
        AuctionItem ai= home.create(seller, 
		description, auctiondays, startprice, summary);
	if(ai == null) {
           return Auction.INVALID_ITEM;
	} 
	else {
           return(ai.getId());
	}

        }catch(Exception e){ 
           System.out.println("insert problem="+e);
           return Auction.INVALID_ITEM;
        }
    }
    public void updateResults(java.util.ArrayList ar) 
		throws RemoteException {
       returned=ar; 
       synchronized(ready) {
          ready.notifyAll();
       }
    }

    public ArrayList auditAccounts() {
        this.callee=callee;
        try {
           RegistrationHome regRef = (RegistrationHome)
		Naming.lookup("//localhost/registration2");
           regRef.findLowCreditAccounts(this);
           synchronized(ready) {
              try {
                 ready.wait();
              } catch (InterruptedException e){}
           }
        return (returned);
       }catch (Exception e) {
          System.out.println("error in creditAudit "+e);
       }
      return null;
    }

    public void ejbCreate() throws javax.ejb.CreateException, 
				RemoteException {
        env.put(javax.naming.Context.INITIAL_CONTEXT_FACTORY, 
		"weblogic.jndi.TengahInitialContextFactory");
        try {
            ectx = new InitialContext(env);
        } catch (NamingException e) {
            System.out.println("problem contacting EJB server");
            throw new javax.ejb.CreateException();
        }

        Properties env=System.getProperties();
        env.put("java.rmi.server.codebase", "file:/root/book/");
        env.put("java.security.policy","/root/book/policy");
        UnicastRemoteObject.exportObject(this);
    }

    public void setSessionContext(SessionContext ctx) 
		throws RemoteException {
        this.ctx = ctx;
    }

    public void unsetSessionContext() throws RemoteException {
        ctx = null; 
    } 

    public void ejbRemove() {}
    public void ejbActivate() throws RemoteException {
	System.out.println("activating seller bean");
    }
    public void ejbPassivate() throws RemoteException { 
	System.out.println("passivating seller bean");
    }
}
