package seller;

import java.rmi.RemoteException;
import javax.ejb.*;
import java.util.*;
import java.text.NumberFormat;
import java.io.Serializable;
import javax.naming.*;
import auction.*;
import registration.*;

public class SellerBean implements SessionBean {

    protected SessionContext ctx;
    Properties p = new Properties();

    public int insertItem(String seller, String password, String description, int auctiondays, double startprice, String summary) throws RemoteException { 

        try{
        Context ectx = new InitialContext(p);

	RegistrationHome rhome = (RegistrationHome) ectx.lookup("registration");
	RegistrationPK rpk=new RegistrationPK();
	rpk.theuser=seller;
	Registration newseller=rhome.findByPrimaryKey(rpk);
	if((newseller == null)|| (!newseller.verifyPassword(password))) {
            return(Auction.INVALID_USER);	
	}

        AuctionItemHome home = (AuctionItemHome) ectx.lookup("auctionitems");
        AuctionItem ai= home.create(seller, description, auctiondays, startprice, summary);
	if(ai == null) {
           return Auction.INVALID_ITEM;
	} 
	else {
           return(ai.getId()); 
	}

        }catch(Exception e){ 
           System.out.println("insert problem="+e);
           return Auction.INVALID_ITEM;
        }
    }

    public void ejbCreate() throws CreateException, RemoteException {
        Properties p = new Properties();
        p.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.TengahInitialContextFactory");
    }

    public void setSessionContext(SessionContext ctx) throws RemoteException {
        this.ctx = ctx;
    }

    public void unsetSessionContext() throws RemoteException {   
        ctx = null;  
    } 

    public void ejbRemove() {}
    public void ejbActivate() throws RemoteException { }
    public void ejbPassivate() throws RemoteException { }
}


