/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class ComponentDemo extends Applet
			   implements ComponentListener {
    TextArea display;
    Frame someFrame;

    public void init() {
	someFrame = new SomeFrame(this);

	setLayout(new BorderLayout());

	display = new TextArea(5, 20);
	display.setEditable(false);
	add("Center", display);
    }

    public void stop() {
	someFrame.setVisible(false);
    }

    public void start() {
	someFrame.setVisible(true);
    }

    protected void displayMessage(String message) {
	try {
	    display.append(message + "\n");
	} catch (Exception e) {
	}

	System.out.println(message);
    }

    public void componentHidden(ComponentEvent e) {
	displayMessage("componentHidden event from "
		       + e.getComponent().getClass().getName());
    }

    public void componentMoved(ComponentEvent e) {
	displayMessage("componentMoved event from "
		       + e.getComponent().getClass().getName());
    }

    public void componentResized(ComponentEvent e) {
	displayMessage("componentResized event from "
		       + e.getComponent().getClass().getName());
    }

    public void componentShown(ComponentEvent e) {
	displayMessage("componentShown event from "
		       + e.getComponent().getClass().getName());
    }
}

class SomeFrame extends Frame 
		implements ItemListener {
    Label label;
    Checkbox checkbox;

    SomeFrame(ComponentListener listener) {
	super("SomeFrame");

	label = new Label("This is a Label", Label.CENTER);
	add("Center", label);

	checkbox = new Checkbox("Label visible", true);
	checkbox.addItemListener(this);
	add("South", checkbox);

	label.addComponentListener(listener);
	checkbox.addComponentListener(listener);
	this.addComponentListener(listener);

	pack();
    }

    public void itemStateChanged(ItemEvent e) {
	if (e.getStateChange() == ItemEvent.SELECTED) {
	    label.setVisible(true);
	} else {
	    label.setVisible(false);
	}
    }
}
