/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.applet.Applet;
import java.awt.*;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class ContainerDemo extends Applet 
			   implements ContainerListener,
				      ActionListener {
    TextArea display;
    Panel buttonPanel;
    Button addButton, removeButton, clearButton;
    Vector buttonList;

    public void init() {
	//Initialize an empty list of buttons.
	buttonList = new Vector(10, 10);

	//Create all the components.
	addButton = new Button("Add a button");
	addButton.addActionListener(this);

	removeButton = new Button("Remove a button");
	removeButton.addActionListener(this);

	buttonPanel = new Panel();
	buttonPanel.addContainerListener(this);

	display = new TextArea(5, 20);
	display.setEditable(false);

	clearButton = new Button("Clear text area");
	clearButton.addActionListener(this);

	//Lay out the components.
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	setLayout(gridbag);
	c.fill = GridBagConstraints.BOTH; //Fill entire cell.

        c.weighty = 1.0;  //Button area and message area have equal height.
	c.gridwidth = GridBagConstraints.REMAINDER; //end of row
	gridbag.setConstraints(display, c);
	add(display);

        c.weighty = 0.0;  
	gridbag.setConstraints(clearButton, c);
	add(clearButton);

        c.weightx = 1.0;  //Add/remove buttons have equal width.
	c.gridwidth = 1;  //NOT end of row
	gridbag.setConstraints(addButton, c);
	add(addButton);

	c.gridwidth = GridBagConstraints.REMAINDER; //end of row
	gridbag.setConstraints(removeButton, c);
	add(removeButton);

        c.weighty = 1.0;  //Button area and message area have equal height.
	gridbag.setConstraints(buttonPanel, c);
	add(buttonPanel);
    }

    public void componentAdded(ContainerEvent e) {
	displayMessage(" added to ", e);
    }

    public void componentRemoved(ContainerEvent e) {
	displayMessage(" removed from ", e);
    }

    void displayMessage(String action, ContainerEvent e) {
	display.append(((Button)e.getChild()).getLabel()
		       + " was"
		       + action
		       + e.getContainer().getClass().getName()
		       + "\n");
    }

    /*
     * This could have been implemented as two or three
     * classes or objects, for clarity.
     */
    public void actionPerformed(ActionEvent e) {
	Object source = e.getSource();

	if (source == addButton) {
	    Button newButton = new Button("Button #"
	                                  + (buttonList.size() + 1));
	    buttonList.addElement(newButton);
	    buttonPanel.add(newButton);
	    buttonPanel.validate(); //Make the button show up.
	} else if (source == removeButton) {
	    int lastIndex = buttonList.size() - 1;
	    try {
	        Button nixedButton = (Button)buttonList.elementAt(lastIndex);
	        buttonPanel.remove(nixedButton);
		buttonList.removeElementAt(lastIndex);
	        buttonPanel.validate(); //Make the button disappear.
	    } catch (ArrayIndexOutOfBoundsException exc) {
	    }
	} else if (source == clearButton) {
	    display.setText("");
	}
    }
}

