/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.applet.Applet;
import java.awt.*;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;

public class FocusDemo extends Applet
		       implements FocusListener,
				  ActionListener {

    TextArea display;
    FocusWindow window;
    Button b1, b2;

    public void init() {
	b1 = new Button("Click to bring up a window.");
	b1.addActionListener(this);

	b2 = new Button("Click to clear the display.");
	b2.addActionListener(this);

	display = new TextArea(5, 20);
	display.setEditable(false);

	setLayout(new BorderLayout());
	add("North", b1);
	add("Center", display);
	add("South", b2);

	//Create but don't show window.
	window = new FocusWindow(this);
    }

    public void stop() {
	window.setVisible(false);
    }

    public void focusGained(FocusEvent e) {
	displayMessage("Focus gained", e);
    }

    public void focusLost(FocusEvent e) {
	displayMessage("Focus lost", e);
    }

    void displayMessage(String prefix, FocusEvent e) {
	display.append(prefix
		       + ": "
		       + e.getSource() //XXX
		       + "\n"); 
    }

    public void actionPerformed(ActionEvent e) {
	if (e.getSource() == b1) {
	    window.pack();
	    window.setVisible(true);
	} else {
	    display.setText("");
	}
    }
}

class FocusWindow extends Frame {
    class FocusWindowListener extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
    	    setVisible(false);
        }
    }

    public FocusWindow(FocusListener listener) {
	super("Focus Demo Window");
	this.addFocusListener(listener);
	this.addWindowListener(new FocusWindowListener());

	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	setLayout(gridbag);

	c.fill = GridBagConstraints.HORIZONTAL;
	c.weightx = 1.0;  //Make column as wide as possible.
	TextField textField = new TextField("A TextField");
	textField.addFocusListener(listener);
	gridbag.setConstraints(textField, c);
	add(textField);

	c.weightx = 0.1;  //Widen every other column a bit, when possible. 
	c.fill = GridBagConstraints.NONE;
	Label label = new Label("A Label");
	label.addFocusListener(listener);
	gridbag.setConstraints(label, c);
	add(label);

	Choice choice = new Choice();
	String choiceprefix = "Choice item #";
	for (int i = 0; i < 10; i++) {
	    choice.addItem(choiceprefix + i);
	}
	choice.addFocusListener(listener);
	gridbag.setConstraints(choice, c);
	add(choice);

	c.gridwidth = GridBagConstraints.REMAINDER;
	Button button = new Button("A Button");
	button.addFocusListener(listener);
	gridbag.setConstraints(button, c);
	add(button);

	c.weighty = 1.0;   //Make this row as tall as possible.
	c.weightx = 0.0;   
	c.fill = GridBagConstraints.BOTH;
	List list = new List();
	String listprefix = "List item #";
	for (int i = 0; i < 10; i++) {
	    list.addItem(listprefix + i);
	}
	list.addFocusListener(listener);
	gridbag.setConstraints(list, c);
	add(list);
    }
}
