/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class KeyDemo extends Applet 
                     implements KeyListener,
				ActionListener {
    TextArea displayArea;
    TextField typingArea;

    public void init() {
	Button button = new Button("Clear");
	button.addActionListener(this);

	typingArea = new TextField(20);
	typingArea.addKeyListener(this);

	displayArea = new TextArea(5, 20);
	displayArea.setEditable(false);

	setLayout(new BorderLayout());
	add("Center", displayArea);
	add("North", typingArea);
	add("South", button);
    }

    /** Handle the key typed event from the text field. */
    public void keyTyped(KeyEvent e) {
	displayInfo(e, "KEY TYPED: ");
    }

    /** Handle the key pressed event from the text field. */
    public void keyPressed(KeyEvent e) {
	displayInfo(e, "KEY PRESSED: ");
    }

    /** Handle the key released event from the text field. */
    public void keyReleased(KeyEvent e) {
	displayInfo(e, "KEY RELEASED: ");
    }

    /** Handle the button click. */
    public void actionPerformed(ActionEvent e) {
	//Clear the text components.
	displayArea.setText("");
	typingArea.setText("");

	//Return the focus to the typing area.
	typingArea.requestFocus();
    }

    /*
     * We have to jump through some hoops to avoid
     * trying to print non-printing characters 
     * such as Shift.  (Not only do they not print, 
     * but if you put them in a String, the characters
     * afterward won't show up in the text area.)
     */
    protected void displayInfo(KeyEvent e, String s){
	String charString, keyCodeString, modString, tmpString;

	char c = e.getKeyChar();
	int keyCode = e.getKeyCode();
	int modifiers = e.getModifiers();

	if (Character.isISOControl(c)) {
	    charString = "key character = (an unprintable control character)";
	} else {
	    charString = "key character = '" + c + "'";
	}

	keyCodeString = "key code = " + keyCode
			+ " ("
			+ KeyEvent.getKeyText(keyCode)
			+ ")";

	modString = "modifiers = " + modifiers;
	tmpString = KeyEvent.getKeyModifiersText(modifiers);
	if (tmpString.length() > 0) {
	    modString += " (" + tmpString + ")";
	} else {
	    modString += " (no modifiers)";
	}

	displayArea.append(s
                           + "\n    "
	                   + charString 
	                   + "\n    "
		           + keyCodeString
                           + "\n    "
		           + modString
		           + "\n");
    }
}
