/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.applet.Applet;
import java.awt.*;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;

public class MouseDemo extends Applet 
                       implements MouseListener {
    BlankArea blankArea;
    TextArea textArea;
    static final int maxInt = java.lang.Integer.MAX_VALUE;

    public void init() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        setLayout(gridbag);

        c.fill = GridBagConstraints.BOTH;
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.weightx = 1.0;
        c.weighty = 1.0;

	c.insets = new Insets(1, 1, 1, 1);
        blankArea = new BlankArea();
        gridbag.setConstraints(blankArea, c);
        add(blankArea);

	c.insets = new Insets(0, 0, 0, 0);
        textArea = new TextArea(5, 20);
        textArea.setEditable(false);
        gridbag.setConstraints(textArea, c);
        add(textArea);

        //Register for mouse events on blankArea and applet (panel).
        blankArea.addMouseListener(this);
        addMouseListener(this);
    }

    public void mousePressed(MouseEvent e) {
       saySomething("Mouse button press", e);
    }

    public void mouseReleased(MouseEvent e) {
       saySomething("Mouse button release", e);
    }

    public void mouseEntered(MouseEvent e) {
       saySomething("Cursor enter", e);
    }

    public void mouseExited(MouseEvent e) {
       saySomething("Cursor exit", e);
    }

    public void mouseClicked(MouseEvent e) {
       saySomething("Mouse button click", e);
    }

    void saySomething(String eventDescription, MouseEvent e) {
        textArea.append(eventDescription + " detected on "
                        + e.getComponent().getClass().getName()
                        + ".\n");
        textArea.setCaretPosition(maxInt); //hack to scroll to bottom
    }
}

class BlankArea extends Canvas {
    Dimension minSize = new Dimension(100, 100);

    public Dimension getMinimumSize() {
	return minSize;
    }

    public Dimension getPreferredSize() {
	return minSize;
    }

    public void paint(Graphics g) {
	Dimension size = getSize();
	g.drawRect(0, 0, size.width - 1, size.height - 1);
    }
}
