/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JComponent;

public class BoxLayoutDemo {
    static int NUM_SQUARES = 5;
    static float[] alignment = {0.0f, 0.25f, 0.5f, 0.75f, 1.0f};

    public static void main(String[] args) {
	Panel panel = new Panel();
       	panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

	/* Create the squares. */
	Square square = null;
	for (int i = 0; i < BoxLayoutDemo.NUM_SQUARES; i++) {
	    square = new Square();
	    square.setAlignmentX(0.5f);
	    square.setAlignmentY(alignment[i]);
	    square.normalHue = Color.getHSBColor(alignment[i], 0.4f, 0.85f);
	    panel.add(square);
	}

	/* Create the instructions. */
	Label label = new Label("Click a box to change its Y alignment.");

	WindowListener l = new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {System.exit(0);}
	};

	Frame f = new Frame("Test Box Layout");
	f.add("Center", panel);
	f.add("South", label);
	f.addWindowListener(l); 
	f.pack();
	f.show();
    }
}


class Square extends JComponent {
    public Color normalHue;
    private final Dimension preferredSize;

    public Square() {
	int pixelsPerSide = (int)(50.0 * Math.random()) + 50;
	preferredSize = new Dimension(pixelsPerSide, pixelsPerSide);

	MouseListener l = new MouseAdapter() {
	    public void mousePressed(MouseEvent e) {
		Dimension size = getSize();
		float alignment = (float)(e.getY())
				/ (float)size.height;

		// Round to the nearest 1/20th.
		int tmp = Math.round(alignment * 20.0f); 
		alignment = (float)tmp / 20.0f;

		setAlignmentY(alignment);
		invalidate();
		getParent().validate();
	    }
	};
	addMouseListener(l);
    }

    public void paint(Graphics g) {
	Dimension size = getSize();
	float alignmentY = getAlignmentY();

	g.setColor(normalHue);
	g.fill3DRect(0, 0, size.width, size.height, true);

	/* Draw a horizontal white line at the alignment point.*/
	g.setColor(Color.white);
	int y = (int)(alignmentY * (float)size.height) - 1;
	g.drawLine(0, y, size.width - 1, y);

	/* Say what the alignment point is. */
	g.setColor(Color.black);
	g.drawString(Float.toString(alignmentY), 3, size.height - 3);

	super.paint(g);
    }


    public Dimension getPreferredSize() {
	return preferredSize;
    }

    public Dimension getMaximumSize() {
	return preferredSize;
    }

    public Dimension getMinimumSize() {
	return preferredSize;
    }
}

