/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.ImageIcon;

public class ButtonDemo extends JPanel
                        implements java.awt.event.ActionListener {

JButton b1, b2, b3;

    public ButtonDemo() {
	super(true);     // true = please double buffer
	ImageIcon leftButtonIcon = new ImageIcon("right.gif");
	ImageIcon middleButtonIcon = new ImageIcon("middle.gif");
	ImageIcon rightButtonIcon = new ImageIcon("left.gif");

        b1 = new JButton("Disable middle button", leftButtonIcon);
	b1.setVerticalTextPosition(AbstractButton.CENTER);
	b1.setHorizontalTextPosition(AbstractButton.LEFT);
	b1.setKeyAccelerator('d');
	b1.setActionCommand("disable");

        b2 = new JButton("Middle button", middleButtonIcon);
	b2.setVerticalTextPosition(AbstractButton.BOTTOM);
	b2.setHorizontalTextPosition(AbstractButton.CENTER);
	b2.setKeyAccelerator('m');

        b3 = new JButton("Enable middle button", rightButtonIcon);
	//Use the default text position of CENTER, RIGHT.
	b3.setKeyAccelerator('e');
	b3.setActionCommand("enable");
        b3.setEnabled(false);

	//Listen for actions on buttons 1 and 3.
	b1.addActionListener(this);
	b3.addActionListener(this);

        //Add Components to the JPanel, using the default FlowLayout. 
        add(b1);
        add(b2);
        add(b3);
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        if (e.getActionCommand().equals("disable")) {
            b2.setEnabled(false);
            b1.setEnabled(false);
            b3.setEnabled(true);
        } else { 
            b2.setEnabled(true);
            b1.setEnabled(true);
            b3.setEnabled(false);
        }
    }
    
    public static void main(String[] args) {
	/*
	 * Create a window.  Use JFrame since this window will include 
	 * lightweight components.
	 */
	JFrame frame = new JFrame("ButtonDemo");

	WindowListener l = new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {System.exit(0);}
	};
	frame.addWindowListener(l);

	frame.add("Center", new ButtonDemo());
	frame.pack();
	frame.show();
    }
}
