/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.JCheckbox;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.ChangeEvent;

/**
 * An application that displays two JCheckboxes. 
 */
public class CheckboxDemo extends JPanel {
    static JFrame frame;
    static String first = new String("Button 1");
    static String second = new String("Button 2");

    public CheckboxDemo() {
	super(true);

	// Create the buttons.
	JCheckbox firstButton = new JCheckbox(first);
        firstButton.setKeyAccelerator('1'); 
	firstButton.setActionCommand(first);
	firstButton.setSelected(true);

	JCheckbox secondButton = new JCheckbox(second);
        secondButton.setKeyAccelerator('2'); 
	secondButton.setActionCommand(second);

        // Register a listener for the checkboxes.
	CheckboxListener myListener = new CheckboxListener();
	firstButton.addActionListener(myListener);
	firstButton.addChangeListener(myListener);
	firstButton.addItemListener(myListener);
	secondButton.addActionListener(myListener);
	secondButton.addChangeListener(myListener);
	secondButton.addItemListener(myListener);

	add(firstButton);
	add(secondButton);
    }


    /** Listens to the checkboxes. */
    class CheckboxListener implements ItemListener, //only event type needed
				   ActionListener, //for curiosity only
				   ChangeListener {  //for curiosity only
	public void itemStateChanged(ItemEvent e) {
	    System.out.println("ItemEvent received: " 
			       + e.getItem()
			       + " is now "
			       + ((e.getStateChange() == ItemEvent.SELECTED)?
				   "selected.":"unselected"));
	}

	public void actionPerformed(ActionEvent e) {
	    String factoryName = null;

	    System.out.print("ActionEvent received: ");
	    if (e.getActionCommand() == first) {
		System.out.println(first + " pressed.");
	    } else {
		System.out.println(second + " pressed.");
	    }
	}

	public void stateChanged(ChangeEvent e) {
	    System.out.println("ChangeEvent received from: "
			       + e.getSource());
	}
    }

    public static void main(String s[]) {
         WindowListener l = new WindowAdapter() {
             public void windowClosing(WindowEvent e) {System.exit(0);}
         };
 
         frame = new JFrame("CheckboxDemo");
         frame.addWindowListener(l);
         frame.add("Center", new CheckboxDemo());
         frame.pack();
         frame.setVisible(true);
    }
}
